/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.http.codec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.http.codec.Codec;

public class MultiLineJsonCodec
implements Codec<List<Map<String, Object>>> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String REGEX = "\\r?\\n";
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final Pattern multiLineJsonSplitPattern = Pattern.compile("\\r?\\n");

    private static boolean isInvalidLine(String str) {
        return str == null || str.isEmpty() || str.isBlank();
    }

    @Override
    public List<Map<String, Object>> parse(HttpData httpData) throws IOException {
        String[] jsonLines;
        ArrayList<Map<String, Object>> jsonListData = new ArrayList<Map<String, Object>>();
        String requestBody = new String(httpData.toInputStream().readAllBytes(), StandardCharsets.UTF_8);
        for (String jsonLine : jsonLines = multiLineJsonSplitPattern.split(requestBody)) {
            if (MultiLineJsonCodec.isInvalidLine(jsonLine)) {
                throw new IOException("Error processing request payload.");
            }
            jsonListData.add((Map)objectMapper.readValue(jsonLine, MAP_TYPE_REFERENCE));
        }
        return jsonListData;
    }

    @Override
    public void validate(HttpData content) throws IOException {
    }

    @Override
    public void serializeSplit(HttpData content, Consumer<String> serializedBodyConsumer, int splitLength) throws IOException {
    }
}

