/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.server;

import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.encoding.DecodingService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.GrpcServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import com.linecorp.armeria.server.throttling.ThrottlingRejectHandler;
import com.linecorp.armeria.server.throttling.ThrottlingService;
import com.linecorp.armeria.server.throttling.ThrottlingStrategy;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Function;
import org.opensearch.dataprepper.GrpcRequestExceptionHandler;
import org.opensearch.dataprepper.HttpRequestExceptionHandler;
import org.opensearch.dataprepper.armeria.authentication.ArmeriaHttpAuthenticationProvider;
import org.opensearch.dataprepper.armeria.authentication.GrpcAuthenticationProvider;
import org.opensearch.dataprepper.http.LogThrottlingRejectHandler;
import org.opensearch.dataprepper.http.LogThrottlingStrategy;
import org.opensearch.dataprepper.http.certificate.CertificateProviderFactory;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.log.Log;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.model.Certificate;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.server.HealthGrpcService;
import org.opensearch.dataprepper.plugins.server.RetryInfoConfig;
import org.opensearch.dataprepper.plugins.server.ServerConfiguration;
import org.slf4j.Logger;

public class CreateServer {
    private final ServerConfiguration serverConfiguration;
    private final Logger LOG;
    private final PluginMetrics pluginMetrics;
    private String sourceName;
    private String pipelineName;
    private static final String HTTP_HEALTH_CHECK_PATH = "/health";
    private static final String REGEX_HEALTH = "regex:^/(?!health$).*$";
    private static final String PIPELINE_NAME_PLACEHOLDER = "${pipelineName}";
    private static final RetryInfoConfig DEFAULT_RETRY_INFO = new RetryInfoConfig(Duration.ofMillis(100L), Duration.ofMillis(2000L));

    public CreateServer(ServerConfiguration serverConfiguration, Logger LOG, PluginMetrics pluginMetrics, String sourceName, String pipelineName) {
        this.serverConfiguration = serverConfiguration;
        this.LOG = LOG;
        this.pluginMetrics = pluginMetrics;
        this.sourceName = sourceName;
        this.pipelineName = pipelineName;
    }

    public Server createGRPCServer(GrpcAuthenticationProvider authenticationProvider, List<GRPCServiceConfig<?, ?>> grpcServiceConfigs, CertificateProvider certificateProvider) {
        List<ServerInterceptor> serverInterceptors = this.getAuthenticationInterceptor(authenticationProvider);
        GrpcServiceBuilder grpcServiceBuilder = GrpcService.builder().useClientTimeoutHeader(false).useBlockingTaskExecutor(true).exceptionHandler(this.createGrpExceptionHandler());
        for (GRPCServiceConfig<?, ?> serviceConfig : grpcServiceConfigs) {
            if (serviceConfig.getPath() != null && serviceConfig.getMethodDescriptor() != null) {
                String transformedPath = serviceConfig.getPath().replace(PIPELINE_NAME_PLACEHOLDER, this.pipelineName);
                grpcServiceBuilder.addService(transformedPath, ServerInterceptors.intercept((BindableService)serviceConfig.getService(), serverInterceptors), serviceConfig.getMethodDescriptor());
                this.LOG.info("Adding service with path: {}", (Object)transformedPath);
                continue;
            }
            grpcServiceBuilder.addService(ServerInterceptors.intercept((BindableService)serviceConfig.getService(), serverInterceptors));
            this.LOG.info("Adding service without specific path");
        }
        if (this.serverConfiguration.hasHealthCheck()) {
            this.LOG.info("Health check is enabled");
            grpcServiceBuilder.addService((BindableService)new HealthGrpcService());
        }
        if (this.serverConfiguration.hasProtoReflectionService()) {
            this.LOG.info("Proto reflection service is enabled");
            grpcServiceBuilder.addService(ProtoReflectionService.newInstance());
        }
        grpcServiceBuilder.enableUnframedRequests(this.serverConfiguration.enableUnframedRequests());
        ServerBuilder sb = Server.builder();
        sb.disableServerHeader();
        if (CompressionOption.NONE.equals((Object)this.serverConfiguration.getCompression())) {
            sb.service((HttpServiceWithRoutes)grpcServiceBuilder.build(), new Function[0]);
        } else {
            sb.service((HttpServiceWithRoutes)grpcServiceBuilder.build(), new Function[]{DecodingService.newDecorator()});
        }
        if (this.serverConfiguration.enableHttpHealthCheck()) {
            sb.service(HTTP_HEALTH_CHECK_PATH, (HttpService)HealthCheckService.builder().longPolling(0L).build());
        }
        if (this.serverConfiguration.getAuthentication() != null) {
            Optional optionalHttpAuthenticationService = authenticationProvider.getHttpAuthenticationService();
            if (this.serverConfiguration.isUnauthenticatedHealthCheck()) {
                optionalHttpAuthenticationService.ifPresent(httpAuthenticationService -> sb.decorator(REGEX_HEALTH, httpAuthenticationService));
            } else {
                optionalHttpAuthenticationService.ifPresent(arg_0 -> ((ServerBuilder)sb).decorator(arg_0));
            }
        }
        sb.requestTimeoutMillis((long)this.serverConfiguration.getRequestTimeoutInMillis());
        if (this.serverConfiguration.getMaxRequestLength() != null) {
            sb.maxRequestLength(this.serverConfiguration.getMaxRequestLength().getBytes());
        }
        if (this.serverConfiguration.isSsl() || this.serverConfiguration.useAcmCertForSSL()) {
            this.LOG.info("SSL/TLS is enabled.");
            Certificate certificate = certificateProvider.getCertificate();
            sb.https(this.serverConfiguration.getPort().intValue()).tls((InputStream)new ByteArrayInputStream(certificate.getCertificate().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(certificate.getPrivateKey().getBytes(StandardCharsets.UTF_8)));
        } else {
            this.LOG.warn("Creating " + this.sourceName + " without SSL/TLS. This is not secure.");
            this.LOG.warn("In order to set up TLS for the " + this.sourceName + ", go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-trace-source#ssl");
            sb.http(this.serverConfiguration.getPort().intValue());
        }
        BlockingTaskExecutor blockingTaskExecutor = BlockingTaskExecutor.builder().numThreads(this.serverConfiguration.getThreadCount()).threadNamePrefix(this.pipelineName + this.sourceName).build();
        sb.blockingTaskExecutor(blockingTaskExecutor, true);
        return sb.build();
    }

    public <K, V> Server createGRPCServer(GrpcAuthenticationProvider authenticationProvider, BindableService grpcService, CertificateProvider certificateProvider, MethodDescriptor<K, V> methodDescriptor) {
        ArrayList serviceConfigs = new ArrayList();
        if (this.serverConfiguration.getPath() != null) {
            serviceConfigs.add(new GRPCServiceConfig<K, V>(grpcService, this.serverConfiguration.getPath(), methodDescriptor));
        } else {
            serviceConfigs.add(new GRPCServiceConfig(grpcService));
        }
        return this.createGRPCServer(authenticationProvider, serviceConfigs, certificateProvider);
    }

    public Server createHTTPServer(Buffer<Record<Log>> buffer, CertificateProviderFactory certificateProviderFactory, ArmeriaHttpAuthenticationProvider authenticationProvider, HttpRequestExceptionHandler httpRequestExceptionHandler, Object logService) {
        ServerBuilder sb = Server.builder();
        sb.disableServerHeader();
        if (this.serverConfiguration.isSsl()) {
            this.LOG.info("Creating http source with SSL/TLS enabled.");
            CertificateProvider certificateProvider = certificateProviderFactory.getCertificateProvider();
            Certificate certificate = certificateProvider.getCertificate();
            sb.https(this.serverConfiguration.getPort().intValue()).tls((InputStream)new ByteArrayInputStream(certificate.getCertificate().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(certificate.getPrivateKey().getBytes(StandardCharsets.UTF_8)));
        } else {
            this.LOG.warn("Creating " + this.sourceName + " without SSL/TLS. This is not secure.");
            this.LOG.warn("In order to set up TLS for the " + this.sourceName + ", go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/http-source#ssl");
            sb.http(this.serverConfiguration.getPort().intValue());
        }
        if (this.serverConfiguration.getAuthentication() != null) {
            Optional optionalAuthDecorator = authenticationProvider.getAuthenticationDecorator();
            if (this.serverConfiguration.isUnauthenticatedHealthCheck()) {
                optionalAuthDecorator.ifPresent(authDecorator -> sb.decorator(REGEX_HEALTH, authDecorator));
            } else {
                optionalAuthDecorator.ifPresent(arg_0 -> ((ServerBuilder)sb).decorator(arg_0));
            }
        }
        sb.maxNumConnections(this.serverConfiguration.getMaxConnectionCount());
        sb.requestTimeout(Duration.ofMillis(this.serverConfiguration.getRequestTimeoutInMillis()));
        if (this.serverConfiguration.getMaxRequestLength() != null) {
            sb.maxRequestLength(this.serverConfiguration.getMaxRequestLength().getBytes());
        }
        int threads = this.serverConfiguration.getThreadCount();
        ScheduledThreadPoolExecutor blockingTaskExecutor = new ScheduledThreadPoolExecutor(threads);
        sb.blockingTaskExecutor((ScheduledExecutorService)blockingTaskExecutor, true);
        int maxPendingRequests = this.serverConfiguration.getMaxPendingRequests();
        LogThrottlingStrategy logThrottlingStrategy = new LogThrottlingStrategy(maxPendingRequests, blockingTaskExecutor.getQueue());
        LogThrottlingRejectHandler logThrottlingRejectHandler = new LogThrottlingRejectHandler(maxPendingRequests, this.pluginMetrics);
        String httpSourcePath = this.serverConfiguration.getPath().replace(PIPELINE_NAME_PLACEHOLDER, this.pipelineName);
        sb.decorator(httpSourcePath, ThrottlingService.newDecorator((ThrottlingStrategy)logThrottlingStrategy, (ThrottlingRejectHandler)logThrottlingRejectHandler));
        if (CompressionOption.NONE.equals((Object)this.serverConfiguration.getCompression())) {
            sb.annotatedService(httpSourcePath, logService, new Object[]{httpRequestExceptionHandler});
        } else {
            sb.annotatedService(httpSourcePath, logService, DecodingService.newDecorator(), new Object[]{httpRequestExceptionHandler});
        }
        if (this.serverConfiguration.hasHealthCheck()) {
            this.LOG.info("HTTP source health check is enabled");
            sb.service(HTTP_HEALTH_CHECK_PATH, (HttpService)HealthCheckService.builder().longPolling(0L).build());
        }
        return sb.build();
    }

    private GrpcExceptionHandlerFunction createGrpExceptionHandler() {
        RetryInfoConfig retryInfo = this.serverConfiguration.getRetryInfo() != null ? this.serverConfiguration.getRetryInfo() : DEFAULT_RETRY_INFO;
        return new GrpcRequestExceptionHandler(this.pluginMetrics, retryInfo.getMinDelay(), retryInfo.getMaxDelay());
    }

    private List<ServerInterceptor> getAuthenticationInterceptor(GrpcAuthenticationProvider authenticationProvider) {
        ServerInterceptor authenticationInterceptor = authenticationProvider.getAuthenticationInterceptor();
        if (authenticationInterceptor == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(authenticationInterceptor);
    }

    public static class GRPCServiceConfig<K, V> {
        private final BindableService service;
        private final String path;
        private final MethodDescriptor<K, V> methodDescriptor;

        public GRPCServiceConfig(BindableService service, String path, MethodDescriptor<K, V> methodDescriptor) {
            this.service = service;
            this.path = path;
            this.methodDescriptor = methodDescriptor;
        }

        public GRPCServiceConfig(BindableService service) {
            this.service = service;
            this.path = null;
            this.methodDescriptor = null;
        }

        public BindableService getService() {
            return this.service;
        }

        public String getPath() {
            return this.path;
        }

        public MethodDescriptor<K, V> getMethodDescriptor() {
            return this.methodDescriptor;
        }
    }
}

