/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.dlq.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.plugins.dlq.DlqProvider;
import org.opensearch.dataprepper.plugins.dlq.DlqWriter;
import org.opensearch.dataprepper.plugins.dlq.s3.S3DlqWriter;
import org.opensearch.dataprepper.plugins.dlq.s3.S3DlqWriterConfig;

@DataPrepperPlugin(name="s3", pluginType=DlqProvider.class, pluginConfigurationType=S3DlqWriterConfig.class)
public class S3DlqProvider
implements DlqProvider {
    private static final String S3_DLQ_PLUGIN_NAME = "s3";
    private final S3DlqWriterConfig s3DlqWriterConfig;

    @DataPrepperPluginConstructor
    public S3DlqProvider(S3DlqWriterConfig s3DlqWriterConfig) {
        Objects.requireNonNull(s3DlqWriterConfig);
        this.s3DlqWriterConfig = s3DlqWriterConfig;
    }

    @Override
    public Optional<DlqWriter> getDlqWriter(String pluginMetricsScope) {
        Preconditions.checkArgument((pluginMetricsScope == null || !pluginMetricsScope.isEmpty() ? 1 : 0) != 0, (Object)"missing pluginMetricsScope for DLQ Writer");
        PluginMetrics pluginMetrics = PluginMetrics.fromNames((String)S3_DLQ_PLUGIN_NAME, (String)pluginMetricsScope);
        ObjectMapper objectMapper = new ObjectMapper();
        return Optional.of(new S3DlqWriter(this.s3DlqWriterConfig, objectMapper, pluginMetrics));
    }
}

