/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperExtensionPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.model.plugin.ExtensionProvider;
import org.opensearch.dataprepper.plugins.encryption.DefaultEncryptionHttpHandler;
import org.opensearch.dataprepper.plugins.encryption.DefaultEncryptionSupplier;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplier;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplierFactory;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeyWriterFactory;
import org.opensearch.dataprepper.plugins.encryption.EncryptionEngineConfiguration;
import org.opensearch.dataprepper.plugins.encryption.EncryptionEngineFactory;
import org.opensearch.dataprepper.plugins.encryption.EncryptionHttpHandler;
import org.opensearch.dataprepper.plugins.encryption.EncryptionHttpHandlerExtensionProvider;
import org.opensearch.dataprepper.plugins.encryption.EncryptionPluginConfig;
import org.opensearch.dataprepper.plugins.encryption.EncryptionRefreshJob;
import org.opensearch.dataprepper.plugins.encryption.EncryptionRotationHandler;
import org.opensearch.dataprepper.plugins.encryption.EncryptionRotationHandlerFactory;
import org.opensearch.dataprepper.plugins.encryption.EncryptionSupplier;
import org.opensearch.dataprepper.plugins.encryption.EncryptionSupplierExtensionProvider;
import org.opensearch.dataprepper.plugins.encryption.KeyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperExtensionPlugin(modelType=EncryptionPluginConfig.class, rootKeyJsonPath="/encryption", allowInPipelineConfigurations=true)
public class EncryptionPlugin
implements ExtensionPlugin {
    static final int PERIOD_IN_SECONDS = 60;
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionPlugin.class);
    private final EncryptionSupplier encryptionSupplier;
    private final EncryptionHttpHandler encryptionHttpHandler;
    private ScheduledExecutorService scheduledExecutorService;
    private PluginMetrics pluginMetrics;

    @DataPrepperPluginConstructor
    public EncryptionPlugin(EncryptionPluginConfig encryptionPluginConfig) {
        KeyProviderFactory keyProviderFactory = KeyProviderFactory.create();
        EncryptionEngineFactory encryptionEngineFactory = EncryptionEngineFactory.create(keyProviderFactory);
        EncryptedDataKeySupplierFactory encryptedDataKeySupplierFactory = EncryptedDataKeySupplierFactory.create();
        if (encryptionPluginConfig != null) {
            this.encryptionSupplier = new DefaultEncryptionSupplier(encryptionPluginConfig, encryptionEngineFactory, encryptedDataKeySupplierFactory);
            this.pluginMetrics = PluginMetrics.fromPrefix((String)"encryption");
            EncryptedDataKeyWriterFactory encryptedDataKeyWriterFactory = new EncryptedDataKeyWriterFactory();
            EncryptionRotationHandlerFactory encryptionRotationHandlerFactory = EncryptionRotationHandlerFactory.create(this.pluginMetrics, encryptedDataKeyWriterFactory);
            Set<EncryptionRotationHandler> encryptionRotationHandlers = encryptionPluginConfig.getEncryptionConfigurationMap().entrySet().stream().filter(entry -> ((EncryptionEngineConfiguration)entry.getValue()).rotationEnabled()).map(entry -> encryptionRotationHandlerFactory.createEncryptionRotationHandler((String)entry.getKey(), (EncryptionEngineConfiguration)entry.getValue())).collect(Collectors.toSet());
            this.encryptionHttpHandler = DefaultEncryptionHttpHandler.create(encryptionRotationHandlers);
            this.submitEncryptionRefreshJobs(encryptionPluginConfig, this.encryptionSupplier);
        } else {
            this.encryptionSupplier = new DefaultEncryptionSupplier(new EncryptionPluginConfig(), encryptionEngineFactory, encryptedDataKeySupplierFactory);
            this.encryptionHttpHandler = DefaultEncryptionHttpHandler.create(Collections.emptySet());
        }
    }

    public void apply(ExtensionPoints extensionPoints) {
        extensionPoints.addExtensionProvider((ExtensionProvider)new EncryptionSupplierExtensionProvider(this.encryptionSupplier));
        extensionPoints.addExtensionProvider((ExtensionProvider)new EncryptionHttpHandlerExtensionProvider(this.encryptionHttpHandler));
    }

    public void shutdown() {
        if (this.scheduledExecutorService != null) {
            LOG.info("Shutting down secrets refreshing tasks.");
            this.scheduledExecutorService.shutdown();
            try {
                if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    LOG.warn("Secrets refreshing tasks did not terminate in time, forcing termination");
                    this.scheduledExecutorService.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                LOG.info("Encountered interruption terminating the secrets refreshing tasks execution, attempting to force the termination");
                this.scheduledExecutorService.shutdownNow();
            }
        }
    }

    private void submitEncryptionRefreshJobs(EncryptionPluginConfig encryptionPluginConfig, EncryptionSupplier encryptionSupplier) {
        Map<String, EncryptionEngineConfiguration> encryptionEngineConfigurationMap = encryptionPluginConfig.getEncryptionConfigurationMap();
        Map<String, EncryptedDataKeySupplier> rotationEnabledEncryptionIdToEncryptedDataSuppliers = encryptionEngineConfigurationMap.entrySet().stream().filter(entry -> ((EncryptionEngineConfiguration)entry.getValue()).rotationEnabled()).collect(Collectors.toMap(Map.Entry::getKey, entry -> encryptionSupplier.getEncryptedDataKeySupplier((String)entry.getKey())));
        if (!rotationEnabledEncryptionIdToEncryptedDataSuppliers.isEmpty()) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            rotationEnabledEncryptionIdToEncryptedDataSuppliers.forEach((encryptionId, encryptedDataKeySupplier) -> {
                EncryptionEngineConfiguration encryptionEngineConfiguration = (EncryptionEngineConfiguration)encryptionEngineConfigurationMap.get(encryptionId);
                long jitterDelay = ThreadLocalRandom.current().nextLong(60L);
                this.scheduledExecutorService.scheduleAtFixedRate(new EncryptionRefreshJob((String)encryptionId, (EncryptedDataKeySupplier)encryptedDataKeySupplier, this.pluginMetrics), jitterDelay, encryptionEngineConfiguration.getRotationInterval().toSeconds(), TimeUnit.SECONDS);
            });
        }
    }
}

