/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import org.opensearch.dataprepper.model.encryption.EncryptionEngine;
import org.opensearch.dataprepper.plugins.encryption.DefaultEncryptionEngine;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplier;
import org.opensearch.dataprepper.plugins.encryption.EncryptionContext;
import org.opensearch.dataprepper.plugins.encryption.EncryptionEngineConfiguration;
import org.opensearch.dataprepper.plugins.encryption.KeyProviderFactory;
import org.opensearch.dataprepper.plugins.encryption.KmsEncryptionEngineConfiguration;
import org.opensearch.dataprepper.plugins.encryption.KmsKeyProvider;

class EncryptionEngineFactory {
    private final KeyProviderFactory keyProviderFactory;

    public static EncryptionEngineFactory create(KeyProviderFactory keyProviderFactory) {
        return new EncryptionEngineFactory(keyProviderFactory);
    }

    private EncryptionEngineFactory(KeyProviderFactory keyProviderFactory) {
        this.keyProviderFactory = keyProviderFactory;
    }

    public EncryptionEngine createEncryptionEngine(EncryptionEngineConfiguration encryptionEngineConfiguration, EncryptedDataKeySupplier encryptedDataKeySupplier) {
        if (encryptionEngineConfiguration instanceof KmsEncryptionEngineConfiguration) {
            KmsEncryptionEngineConfiguration kmsEncryptionEngineConfiguration = (KmsEncryptionEngineConfiguration)encryptionEngineConfiguration;
            KmsKeyProvider keyProvider = this.keyProviderFactory.createKmsKeyProvider(kmsEncryptionEngineConfiguration);
            EncryptionContext encryptionContext = new EncryptionContext();
            return new DefaultEncryptionEngine(keyProvider, encryptionContext, encryptedDataKeySupplier);
        }
        throw new IllegalArgumentException("Unsupported encryption engine configuration.");
    }
}

