/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

class EncryptionContext {
    static final String AES_ALGORITHM = "AES";
    static final Integer MAXIMUM_CACHED_KEYS = 5;
    private final Cache<byte[], Cipher> encryptionCipherCache = Caffeine.newBuilder().maximumSize((long)MAXIMUM_CACHED_KEYS.intValue()).build();
    private final Cache<byte[], Cipher> decryptionCipherCache = Caffeine.newBuilder().maximumSize((long)MAXIMUM_CACHED_KEYS.intValue()).build();

    EncryptionContext() {
    }

    Cipher createEncryptionCipher(byte[] encryptionKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return this.createCipher(1, encryptionKey);
    }

    Cipher createDecryptionCipher(byte[] encryptionKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return this.createCipher(2, encryptionKey);
    }

    private Cipher createCipher(int encryptMode, byte[] encryptionKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(encryptionKey, AES_ALGORITHM);
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(encryptMode, secretKeySpec);
        return cipher;
    }

    public Cipher getOrCreateEncryptionCipher(byte[] encryptionKey) {
        return this.encryptionCipherCache.asMap().computeIfAbsent(encryptionKey, key -> {
            try {
                return this.createEncryptionCipher(encryptionKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Cipher getOrCreateDecryptionCipher(byte[] encryptionKey) {
        return this.decryptionCipherCache.asMap().computeIfAbsent(encryptionKey, key -> {
            try {
                return this.createDecryptionCipher(encryptionKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

