/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeyWriter;
import org.opensearch.dataprepper.plugins.encryption.S3BucketAndPrefix;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

class S3EncryptedDataKeyWriter
implements EncryptedDataKeyWriter {
    static final String S3_PREFIX = "s3://";
    static final String KEY_NAME_FORMAT = "%s.key";
    private static final String FULL_KEY_FORMAT = "%s/%s";
    private final String encryptionKeyDirectory;
    private final S3BucketAndPrefix s3BucketAndPrefix;
    private final S3Client s3Client;

    public S3EncryptedDataKeyWriter(S3Client s3Client, String encryptionKeyDirectory) {
        this.s3Client = s3Client;
        this.encryptionKeyDirectory = encryptionKeyDirectory;
        this.s3BucketAndPrefix = S3BucketAndPrefix.fromS3Uri(encryptionKeyDirectory);
    }

    @Override
    public void writeEncryptedDataKey(String encryptedDataKey) throws IOException {
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.s3BucketAndPrefix.getBucketName()).key(this.buildKey(this.s3BucketAndPrefix.getPrefix())).build();
        PutObjectResponse putObjectResponse = this.s3Client.putObject(putObjectRequest, RequestBody.fromString((String)encryptedDataKey));
        if (!putObjectResponse.sdkHttpResponse().isSuccessful()) {
            throw new IOException(String.format("Failed to write S3 encryption key directory due to status code: %d", putObjectResponse.sdkHttpResponse().statusCode()));
        }
    }

    private String buildKey(String keyPathPrefix) {
        Instant now = Instant.now();
        String iso8601 = DateTimeFormatter.ISO_INSTANT.format(now);
        String key = String.format(KEY_NAME_FORMAT, iso8601);
        return keyPathPrefix == null ? key : String.format(FULL_KEY_FORMAT, keyPathPrefix, key);
    }
}

