/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.export;

import java.time.Duration;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition.DataFilePartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.state.DataFileProgressState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFileCheckpointer {
    private static final Logger LOG = LoggerFactory.getLogger(DataFileCheckpointer.class);
    static final Duration CHECKPOINT_OWNERSHIP_TIMEOUT_INCREASE = Duration.ofMinutes(10L);
    private final EnhancedSourceCoordinator enhancedSourceCoordinator;
    private final DataFilePartition dataFilePartition;

    public DataFileCheckpointer(EnhancedSourceCoordinator enhancedSourceCoordinator, DataFilePartition dataFilePartition) {
        this.enhancedSourceCoordinator = enhancedSourceCoordinator;
        this.dataFilePartition = dataFilePartition;
    }

    private void setProgressState(int lineNumber) {
        Optional<DataFileProgressState> progressState = this.dataFilePartition.getProgressState();
        progressState.get().setLoaded(lineNumber);
    }

    public void checkpoint(int lineNumber) {
        LOG.debug("Checkpoint data file " + this.dataFilePartition.getKey() + " with line number " + lineNumber);
        this.setProgressState(lineNumber);
        this.enhancedSourceCoordinator.saveProgressStateForPartition((EnhancedSourcePartition)this.dataFilePartition, CHECKPOINT_OWNERSHIP_TIMEOUT_INCREASE);
    }

    public void complete(int lineNumber) {
        LOG.debug("Complete the read of data file " + this.dataFilePartition.getKey() + " with line number " + lineNumber);
        this.setProgressState(lineNumber);
        this.enhancedSourceCoordinator.completePartition((EnhancedSourcePartition)this.dataFilePartition);
    }

    public void release(int lineNumber) {
        LOG.debug("Release the ownership of data file " + this.dataFilePartition.getKey() + " with line number " + lineNumber);
        this.setProgressState(lineNumber);
        this.enhancedSourceCoordinator.giveUpPartition((EnhancedSourcePartition)this.dataFilePartition);
    }

    public void updateDatafileForAcknowledgmentWait(Duration acknowledgmentSetTimeout) {
        this.enhancedSourceCoordinator.saveProgressStateForPartition((EnhancedSourcePartition)this.dataFilePartition, acknowledgmentSetTimeout);
    }
}

