/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition;

import java.time.Instant;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.state.ExportProgressState;

public class ExportPartition
extends EnhancedSourcePartition<ExportProgressState> {
    public static final String PARTITION_TYPE = "EXPORT";
    private final String tableArn;
    private final Instant exportTime;
    private final ExportProgressState state;

    public ExportPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        String[] keySplits = sourcePartitionStoreItem.getSourcePartitionKey().split("\\|");
        this.tableArn = keySplits[0];
        this.exportTime = Instant.ofEpochMilli(Long.valueOf(keySplits[1]));
        this.state = (ExportProgressState)this.convertStringToPartitionProgressState(ExportProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public ExportPartition(String tableArn, Instant exportTime, Optional<ExportProgressState> state) {
        this.tableArn = tableArn;
        this.exportTime = exportTime;
        this.state = state.orElse(null);
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.tableArn + "|" + this.exportTime.toEpochMilli();
    }

    public Optional<ExportProgressState> getProgressState() {
        if (this.state != null) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }

    public String getTableArn() {
        return this.tableArn;
    }

    public Instant getExportTime() {
        return this.exportTime;
    }
}

