/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.crowdstrike.rest;

import java.time.Instant;
import java.util.Map;
import javax.inject.Named;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.plugins.source.crowdstrike.CrowdStrikeSourceConfig;
import org.opensearch.dataprepper.plugins.source.crowdstrike.configuration.AuthenticationConfig;
import org.opensearch.dataprepper.plugins.source.crowdstrike.utils.Constants;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Named
public class CrowdStrikeAuthClient {
    private String bearerToken;
    private Instant expireTime;
    private final String clientId;
    private final String clientSecret;
    RestTemplate restTemplate = new RestTemplate();
    private static final Logger log = LoggerFactory.getLogger(CrowdStrikeAuthClient.class);
    private static final String OAUTH_TOKEN_URL = "https://api.crowdstrike.com/oauth2/token";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRE_IN = "expires_in";
    private final Object tokenRenewLock = new Object();

    public CrowdStrikeAuthClient(CrowdStrikeSourceConfig sourceConfig) {
        AuthenticationConfig authConfig = sourceConfig.getAuthenticationConfig();
        this.clientId = authConfig.getClientId();
        this.clientSecret = authConfig.getClientSecret();
    }

    public void initCredentials() {
        log.info("Getting CrowdStrike Authentication Token");
        this.getAuthToken();
    }

    private void getAuthToken() {
        Object object = this.tokenRenewLock;
        synchronized (object) {
            if (this.isTokenValid()) {
                return;
            }
            log.info(DataPrepperMarkers.NOISY, "You are trying to access token");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            headers.setBasicAuth(this.clientId, this.clientSecret);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            for (int retryCount = 0; retryCount < 6; ++retryCount) {
                try {
                    ResponseEntity response = this.restTemplate.postForEntity(OAUTH_TOKEN_URL, (Object)request, Map.class, new Object[0]);
                    Map tokenData = (Map)response.getBody();
                    this.bearerToken = (String)tokenData.get(ACCESS_TOKEN);
                    this.expireTime = Instant.now().plusSeconds(((Integer)tokenData.get(EXPIRE_IN)).intValue());
                    log.info("Access token acquired successfully");
                    return;
                }
                catch (HttpClientErrorException ex) {
                    this.expireTime = Instant.ofEpochMilli(0L);
                    HttpStatus statusCode = ex.getStatusCode();
                    String statusMessage = ex.getMessage();
                    log.error("Failed to acquire access token. Status code: {}, Error Message: {}", (Object)statusCode, (Object)statusMessage);
                    try {
                        Thread.sleep((long)Constants.RETRY_ATTEMPT_SLEEP_TIME.get(retryCount).intValue() * 1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Sleep in the retry attempt got interrupted", e);
                    }
                }
            }
            String errorMessage = String.format("Failed to acquire access token even after %s retry attempts", 6);
            log.error(errorMessage);
            throw new UnauthorizedException(errorMessage);
        }
    }

    protected boolean isTokenValid() {
        Instant currentTime = Instant.now();
        return this.bearerToken != null && currentTime.isBefore(this.expireTime);
    }

    public void refreshToken() {
        if (this.isTokenValid()) {
            return;
        }
        log.info("Renewing authentication token for CrowdStrike Connector.");
        this.getAuthToken();
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }
}

