/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.confluence;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.opensearch.dataprepper.plugins.source.confluence.models.ConfluenceItem;
import org.opensearch.dataprepper.plugins.source.confluence.utils.ConfluenceContentType;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;

public class ConfluenceItemInfo
implements ItemInfo {
    private String space;
    private String contentType;
    private String id;
    private String itemId;
    private Map<String, Object> metadata;
    private Instant eventTime;

    public ConfluenceItemInfo(String id, String itemId, String space, String contentType, Map<String, Object> metadata, Instant eventTime) {
        this.id = id;
        this.space = space;
        this.contentType = contentType;
        this.itemId = itemId;
        this.metadata = metadata;
        this.eventTime = eventTime;
    }

    public static ConfluenceItemInfoBuilder builder() {
        return new ConfluenceItemInfoBuilder();
    }

    public String getPartitionKey() {
        return this.space + "|" + this.contentType + "|" + String.valueOf(UUID.randomUUID());
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getKeyAttributes() {
        return Map.of("space", this.space);
    }

    public Instant getLastModifiedAt() {
        long updatedAtMillis = this.getMetadataField("lastModified");
        long createdAtMillis = this.getMetadataField("created");
        return createdAtMillis > updatedAtMillis ? Instant.ofEpochMilli(createdAtMillis) : Instant.ofEpochMilli(updatedAtMillis);
    }

    private Long getMetadataField(String fieldName) {
        Object value = this.metadata.get(fieldName);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setEventTime(Instant eventTime) {
        this.eventTime = eventTime;
    }

    public String getSpace() {
        return this.space;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Instant getEventTime() {
        return this.eventTime;
    }

    public static class ConfluenceItemInfoBuilder {
        private Map<String, Object> metadata;
        private Instant eventTime;
        private String id;
        private String itemId;
        private String space;
        private String contentType;

        public ConfluenceItemInfo build() {
            return new ConfluenceItemInfo(this.id, this.itemId, this.space, this.contentType, this.metadata, this.eventTime);
        }

        public ConfluenceItemInfoBuilder withMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ConfluenceItemInfoBuilder withEventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public ConfluenceItemInfoBuilder withItemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public ConfluenceItemInfoBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ConfluenceItemInfoBuilder withSpace(String space) {
            this.space = space;
            return this;
        }

        public ConfluenceItemInfoBuilder withContentBean(ConfluenceItem contentItem) {
            HashMap<String, Object> contentItemMetadata = new HashMap<String, Object>();
            contentItemMetadata.put("space", contentItem.getSpaceItem().getKey());
            contentItemMetadata.put("title", contentItem.getTitle());
            contentItemMetadata.put("created", contentItem.getCreatedTimeMillis());
            contentItemMetadata.put("lastModified", contentItem.getUpdatedTimeMillis());
            contentItemMetadata.put("id", contentItem.getId());
            contentItemMetadata.put("ContentType", ConfluenceContentType.PAGE.getType());
            this.space = contentItem.getSpaceItem().getKey();
            this.id = contentItem.getId();
            this.contentType = ConfluenceContentType.PAGE.getType();
            this.itemId = contentItem.getId();
            this.metadata = contentItemMetadata;
            return this;
        }
    }
}

