/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink;

import java.util.Collection;
import java.util.Objects;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.sink.SinkContext;

@DataPrepperPlugin(name="stdout", pluginType=Sink.class)
public class StdOutSink
implements Sink<Record<Object>> {
    private final String tagsTargetKey;

    @DataPrepperPluginConstructor
    public StdOutSink(PluginSetting pluginSetting, SinkContext sinkContext) {
        this(Objects.nonNull(sinkContext) ? sinkContext.getTagsTargetKey() : null);
    }

    public StdOutSink(String tagsTargetKey) {
        this.tagsTargetKey = tagsTargetKey;
    }

    public StdOutSink() {
        this.tagsTargetKey = null;
    }

    public void output(Collection<Record<Object>> records) {
        for (Record<Object> record : records) {
            this.checkTypeAndPrintObject(record.getData());
        }
    }

    private void checkTypeAndPrintObject(Object object) {
        if (object instanceof Event) {
            String output = ((Event)object).jsonBuilder().includeTags(this.tagsTargetKey).toJsonString();
            System.out.println(output);
            EventHandle eventHandle = ((Event)object).getEventHandle();
            if (eventHandle != null) {
                eventHandle.release(true);
            }
        } else {
            System.out.println(object);
        }
    }

    public void shutdown() {
    }

    public void initialize() {
    }

    public boolean isReady() {
        return true;
    }
}

