/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.hasher;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.model.event.Event;

public class IdentificationKeysHasher {
    private final List<String> identificationKeys;

    public IdentificationKeysHasher(List<String> identificationKeys) {
        this.identificationKeys = identificationKeys;
    }

    public IdentificationKeysMap createIdentificationKeysMapFromEvent(Event event) {
        HashMap<Object, Object> identificationKeysMap = new HashMap<Object, Object>();
        for (String identificationKey : this.identificationKeys) {
            identificationKeysMap.put(identificationKey, event.get(identificationKey, Object.class));
        }
        return new IdentificationKeysMap(identificationKeysMap);
    }

    public static class IdentificationKeysMap {
        private final Map<Object, Object> keyMap;

        public IdentificationKeysMap(Map<Object, Object> keyMap) {
            this.keyMap = keyMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentificationKeysMap that = (IdentificationKeysMap)o;
            return Objects.equals(this.keyMap, that.keyMap);
        }

        public int hashCode() {
            return Objects.hash(this.keyMap);
        }

        public Map<Object, Object> getKeyMap() {
            return this.keyMap;
        }
    }
}

