/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.regex.Pattern;

@Documented
@Constraint(validatedBy={CustomHeadersValidator.class})
@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ValidCustomHeaders {
    public String message() default "Invalid custom headers configuration";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class CustomHeadersValidator
    implements ConstraintValidator<ValidCustomHeaders, Map<String, String>> {
        private static final Pattern VALID_HEADER_NAME_PATTERN = Pattern.compile("^[!#$%&'*+\\-.0-9A-Z^_`a-z|~]+$");

        public void initialize(ValidCustomHeaders constraintAnnotation) {
        }

        public boolean isValid(Map<String, String> headers, ConstraintValidatorContext context) {
            if (headers == null || headers.isEmpty()) {
                return true;
            }
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String headerName = entry.getKey();
                String headerValue = entry.getValue();
                if (headerName == null) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate("Header name cannot be null").addConstraintViolation();
                    return false;
                }
                if (headerValue == null) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate("Header '" + headerName + "' has an empty value").addConstraintViolation();
                    return false;
                }
                if (!VALID_HEADER_NAME_PATTERN.matcher(headerName).matches()) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate("Invalid header name '" + headerName + "'").addConstraintViolation();
                    return false;
                }
                if (!headerValue.trim().isEmpty()) continue;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate("Header '" + headerName + "' has an empty value").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

