/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public class CloudWatchLogsMetrics {
    public static final String CLOUDWATCH_LOGS_REQUESTS_SUCCEEDED = "cloudWatchLogsRequestsSucceeded";
    public static final String CLOUDWATCH_LOGS_EVENTS_SUCCEEDED = "cloudWatchLogsEventsSucceeded";
    public static final String CLOUDWATCH_LOGS_EVENTS_FAILED = "cloudWatchLogsEventsFailed";
    public static final String CLOUDWATCH_LOGS_REQUESTS_FAILED = "cloudWatchLogsRequestsFailed";
    public static final String CLOUDWATCH_LOGS_LARGE_EVENTS_DROPPED = "cloudWatchLogsLargeEventsDropped";
    public static final String CLOUDWATCH_LOGS_LOG_SIZE = "cloudWatchLogsLogSize";
    public static final String CLOUDWATCH_LOGS_REQUEST_SIZE = "cloudWatchLogsRequestSize";
    private final Counter logEventSuccessCounter;
    private final Counter logEventFailCounter;
    private final Counter requestSuccessCount;
    private final Counter requestFailCount;
    private final Counter logLargeEventsDroppedCounter;
    private final DistributionSummary logSizeMetric;
    private final DistributionSummary requestSizeMetric;

    public CloudWatchLogsMetrics(PluginMetrics pluginMetrics) {
        this.logEventSuccessCounter = pluginMetrics.counter(CLOUDWATCH_LOGS_EVENTS_SUCCEEDED);
        this.requestFailCount = pluginMetrics.counter(CLOUDWATCH_LOGS_REQUESTS_FAILED);
        this.logEventFailCounter = pluginMetrics.counter(CLOUDWATCH_LOGS_EVENTS_FAILED);
        this.requestSuccessCount = pluginMetrics.counter(CLOUDWATCH_LOGS_REQUESTS_SUCCEEDED);
        this.logLargeEventsDroppedCounter = pluginMetrics.counter(CLOUDWATCH_LOGS_LARGE_EVENTS_DROPPED);
        this.logSizeMetric = pluginMetrics.summary(CLOUDWATCH_LOGS_LOG_SIZE);
        this.requestSizeMetric = pluginMetrics.summary(CLOUDWATCH_LOGS_REQUEST_SIZE);
    }

    public void increaseLogEventSuccessCounter(int value) {
        this.logEventSuccessCounter.increment((double)value);
    }

    public void increaseRequestSuccessCounter(int value) {
        this.requestSuccessCount.increment((double)value);
    }

    public void increaseLogEventFailCounter(int value) {
        this.logEventFailCounter.increment((double)value);
    }

    public void increaseRequestFailCounter(int value) {
        this.requestFailCount.increment((double)value);
    }

    public void increaseLogLargeEventsDroppedCounter(int value) {
        this.logLargeEventsDroppedCounter.increment((double)value);
    }

    public void recordLogSize(int value) {
        this.logSizeMetric.record((double)value);
    }

    public void recordRequestSize(int value) {
        this.requestSizeMetric.record((double)value);
    }
}

