/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client;

import java.net.URI;
import java.util.Map;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config.AwsConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;

public final class CloudWatchLogsClientFactory {
    private CloudWatchLogsClientFactory() {
    }

    public static CloudWatchLogsClient createCwlClient(AwsConfig awsConfig, AwsCredentialsSupplier awsCredentialsSupplier, Map<String, String> customHeaders, String endpoint) {
        Region region;
        AwsCredentialsOptions awsCredentialsOptions = awsConfig != null ? CloudWatchLogsClientFactory.convertToCredentialOptions(awsConfig) : AwsCredentialsOptions.defaultOptions();
        AwsCredentialsProvider awsCredentialsProvider = awsCredentialsSupplier.getProvider(awsCredentialsOptions);
        Region region2 = region = awsConfig != null ? awsConfig.getAwsRegion() : (Region)awsCredentialsSupplier.getDefaultRegion().get();
        if (awsCredentialsProvider == null || region == null) {
            return null;
        }
        CloudWatchLogsClientBuilder clientBuilder = (CloudWatchLogsClientBuilder)((CloudWatchLogsClientBuilder)((CloudWatchLogsClientBuilder)CloudWatchLogsClient.builder().region(region)).credentialsProvider(awsCredentialsProvider)).overrideConfiguration(CloudWatchLogsClientFactory.createOverrideConfiguration(customHeaders));
        if (endpoint != null && !endpoint.trim().isEmpty()) {
            clientBuilder.endpointOverride(URI.create(endpoint));
        }
        return (CloudWatchLogsClient)clientBuilder.build();
    }

    private static ClientOverrideConfiguration createOverrideConfiguration(Map<String, String> customHeaders) {
        ClientOverrideConfiguration.Builder configBuilder = ClientOverrideConfiguration.builder().retryPolicy(r -> r.numRetries(Integer.valueOf(5)));
        customHeaders.forEach((arg_0, arg_1) -> ((ClientOverrideConfiguration.Builder)configBuilder).putHeader(arg_0, arg_1));
        return (ClientOverrideConfiguration)configBuilder.build();
    }

    private static AwsCredentialsOptions convertToCredentialOptions(AwsConfig awsConfig) {
        return AwsCredentialsOptions.builder().withRegion(awsConfig.getAwsRegion()).withStsRoleArn(awsConfig.getAwsStsRoleArn()).withStsExternalId(awsConfig.getAwsStsExternalId()).withStsHeaderOverrides(awsConfig.getAwsStsHeaderOverrides()).build();
    }
}

