/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.dlq;

import java.util.Objects;

public class CloudWatchLogsSinkDlqData {
    private final int status;
    private final String message;
    private final Object data;

    private CloudWatchLogsSinkDlqData(int status, String message, Object data) {
        this.status = status;
        Objects.requireNonNull(message);
        this.message = message;
        Objects.requireNonNull(data);
        this.data = data;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudWatchLogsSinkDlqData that = (CloudWatchLogsSinkDlqData)o;
        return Objects.equals(this.status, that.status) && Objects.equals(this.message, that.message) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.message, this.data);
    }

    public String toString() {
        return "CloudWatchLogsSinkDlqData{status='" + this.status + "', message='" + this.message + "', data=" + String.valueOf(this.data) + "}";
    }

    public static CloudWatchLogsSinkDlqData createDlqData(int status, Object data, String failureMessage) {
        return CloudWatchLogsSinkDlqData.builder().withData(data).withStatus(status).withMessage(failureMessage).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int status = 0;
        private String message;
        private Object data;

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withData(Object data) {
            this.data = data;
            return this;
        }

        public CloudWatchLogsSinkDlqData build() {
            return new CloudWatchLogsSinkDlqData(this.status, this.message, this.data);
        }
    }
}

