/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.plugins.aws.CredentialsIdentifier;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

class CredentialsCache {
    private final Map<CredentialsIdentifier, AwsCredentialsProvider> credentialsProviderMap = new ConcurrentHashMap<CredentialsIdentifier, AwsCredentialsProvider>();

    CredentialsCache() {
    }

    AwsCredentialsProvider getOrCreate(AwsCredentialsOptions awsCredentialsOptions, Supplier<AwsCredentialsProvider> providerSupplier) {
        CredentialsIdentifier identifier = CredentialsIdentifier.fromAwsCredentialsOption(awsCredentialsOptions);
        return this.credentialsProviderMap.computeIfAbsent(identifier, i -> (AwsCredentialsProvider)providerSupplier.get());
    }
}

