/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.model.plugin.PluginConfigValueTranslator;
import org.opensearch.dataprepper.model.plugin.PluginConfigVariable;
import org.opensearch.dataprepper.plugins.aws.AwsPluginConfigVariable;
import org.opensearch.dataprepper.plugins.aws.SecretsSupplier;

public class AwsSecretsPluginConfigValueTranslator
implements PluginConfigValueTranslator {
    static final String AWS_SECRETS_PREFIX = "aws_secrets";
    static final String SECRET_CONFIGURATION_ID_GROUP = "secretConfigurationId";
    static final String SECRET_KEY_GROUP = "secretKey";
    static final Pattern SECRETS_REF_PATTERN = Pattern.compile(String.format("^(?<%s>[a-zA-Z0-9\\/_+.=@-]+)(:(?<%s>.+))?$", "secretConfigurationId", "secretKey"));
    private final SecretsSupplier secretsSupplier;

    public AwsSecretsPluginConfigValueTranslator(SecretsSupplier secretsSupplier) {
        this.secretsSupplier = secretsSupplier;
    }

    public Object translate(String value) {
        Matcher matcher = SECRETS_REF_PATTERN.matcher(value);
        if (matcher.matches()) {
            String secretId = matcher.group(SECRET_CONFIGURATION_ID_GROUP);
            String secretKey = matcher.group(SECRET_KEY_GROUP);
            return secretKey != null ? this.secretsSupplier.retrieveValue(secretId, secretKey) : this.secretsSupplier.retrieveValue(secretId);
        }
        throw new IllegalArgumentException(String.format("Unable to parse %s or %s according to pattern %s", SECRET_CONFIGURATION_ID_GROUP, SECRET_KEY_GROUP, SECRETS_REF_PATTERN.pattern()));
    }

    public String getPrefix() {
        return AWS_SECRETS_PREFIX;
    }

    public PluginConfigVariable translateToPluginConfigVariable(String value) {
        Matcher matcher = SECRETS_REF_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Unable to parse %s or %s according to pattern %s", SECRET_CONFIGURATION_ID_GROUP, SECRET_KEY_GROUP, SECRETS_REF_PATTERN.pattern()));
        }
        String secretId = matcher.group(SECRET_CONFIGURATION_ID_GROUP);
        String secretKey = matcher.group(SECRET_KEY_GROUP);
        Object secretValue = secretKey != null ? this.secretsSupplier.retrieveValue(secretId, secretKey) : this.secretsSupplier.retrieveValue(secretId);
        return new AwsPluginConfigVariable(this.secretsSupplier, secretId, secretKey, secretValue);
    }
}

