/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.lambda.common.ResponseEventHandlingStrategy;
import org.opensearch.dataprepper.plugins.lambda.processor.exception.StrictResponseModeNotRespectedException;

public class StrictResponseEventHandlingStrategy
implements ResponseEventHandlingStrategy {
    @Override
    public List<Record<Event>> handleEvents(List<Event> parsedEvents, List<Record<Event>> originalRecords, BiConsumer<Event, Event> consumer) {
        if (parsedEvents.size() != originalRecords.size()) {
            throw new StrictResponseModeNotRespectedException("Event count mismatch. The aws_lambda processor is configured with response_events_match set to true. The Lambda function responded with a different number of events. Either set response_events_match to false or investigate your Lambda function to ensure that it returns the same number of events and provided as input. parsedEvents size = " + parsedEvents.size() + ", Original events size = " + originalRecords.size());
        }
        ArrayList<Record<Event>> resultRecords = new ArrayList<Record<Event>>();
        for (int i = 0; i < parsedEvents.size(); ++i) {
            Event responseEvent = parsedEvents.get(i);
            Event originalEvent = (Event)originalRecords.get(i).getData();
            if (consumer != null) {
                consumer.accept(originalEvent, responseEvent);
            } else {
                originalEvent.clear();
            }
            Map responseData = responseEvent.toMap();
            for (Map.Entry entry : responseData.entrySet()) {
                originalEvent.put((String)entry.getKey(), entry.getValue());
            }
            resultRecords.add(originalRecords.get(i));
        }
        return resultRecords;
    }
}

