/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.InternalEventHandle;

public class DefaultEventHandle
implements EventHandle,
InternalEventHandle,
Serializable {
    private Instant externalOriginationTime = null;
    private final Instant internalOriginationTime;
    private WeakReference<AcknowledgementSet> acknowledgementSetRef = null;
    private List<BiConsumer<EventHandle, Boolean>> releaseConsumers;

    public DefaultEventHandle(Instant internalOriginationTime) {
        this.internalOriginationTime = internalOriginationTime;
        this.releaseConsumers = new ArrayList<BiConsumer<EventHandle, Boolean>>();
    }

    @Override
    public void setAcknowledgementSet(AcknowledgementSet acknowledgementSet) {
        this.acknowledgementSetRef = new WeakReference<AcknowledgementSet>(acknowledgementSet);
    }

    @Override
    public void setExternalOriginationTime(Instant externalOriginationTime) {
        this.externalOriginationTime = externalOriginationTime;
    }

    @Override
    public AcknowledgementSet getAcknowledgementSet() {
        if (this.acknowledgementSetRef == null) {
            return null;
        }
        return (AcknowledgementSet)this.acknowledgementSetRef.get();
    }

    @Override
    public Instant getInternalOriginationTime() {
        return this.internalOriginationTime;
    }

    @Override
    public Instant getExternalOriginationTime() {
        return this.externalOriginationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(boolean result) {
        List<BiConsumer<EventHandle, Boolean>> list = this.releaseConsumers;
        synchronized (list) {
            for (BiConsumer<EventHandle, Boolean> consumer : this.releaseConsumers) {
                consumer.accept(this, result);
            }
        }
        AcknowledgementSet acknowledgementSet = this.getAcknowledgementSet();
        if (acknowledgementSet != null) {
            acknowledgementSet.release(this, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRelease(BiConsumer<EventHandle, Boolean> releaseConsumer) {
        List<BiConsumer<EventHandle, Boolean>> list = this.releaseConsumers;
        synchronized (list) {
            this.releaseConsumers.add(releaseConsumer);
        }
    }
}

