/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;

@JsonSerialize(using=PluginModel.PluginModelSerializer.class)
@JsonDeserialize(using=SinkModelDeserializer.class)
public class SinkModel
extends PluginModel {
    SinkModel(String pluginName, List<String> routes, String tagsTargetKey, List<String> includeKeys, List<String> excludeKeys, Map<String, Object> pluginSettings) {
        this(pluginName, new SinkInternalJsonModel(routes, tagsTargetKey, includeKeys, excludeKeys, pluginSettings));
    }

    private SinkModel(String pluginName, SinkInternalJsonModel sinkInnerModel) {
        super(pluginName, sinkInnerModel);
    }

    public Collection<String> getRoutes() {
        return ((SinkInternalJsonModel)this.getInternalJsonModel()).routes;
    }

    public List<String> getIncludeKeys() {
        return ((SinkInternalJsonModel)this.getInternalJsonModel()).includeKeys;
    }

    public List<String> getExcludeKeys() {
        return ((SinkInternalJsonModel)this.getInternalJsonModel()).excludeKeys;
    }

    public String getTagsTargetKey() {
        return ((SinkInternalJsonModel)this.getInternalJsonModel()).tagsTargetKey;
    }

    public static SinkModelBuilder builder(PluginModel pluginModel) {
        return new SinkModelBuilder(pluginModel);
    }

    static class SinkModelDeserializer
    extends PluginModel.AbstractPluginModelDeserializer<SinkModel, SinkInternalJsonModel> {
        SinkModelDeserializer() {
            super(SinkModel.class, SinkInternalJsonModel.class, (x$0, x$1) -> new SinkModel((String)x$0, (SinkInternalJsonModel)x$1), () -> new SinkInternalJsonModel(null, null, null, null));
        }
    }

    private static class SinkInternalJsonModel
    extends PluginModel.InternalJsonModel {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="routes")
        private final List<String> routes;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="tags_target_key")
        private final String tagsTargetKey;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="include_keys")
        private final List<String> includeKeys;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="exclude_keys")
        private final List<String> excludeKeys;

        @JsonCreator
        private SinkInternalJsonModel(@JsonProperty(value="routes") List<String> routes, @JsonProperty(value="tags_target_key") String tagsTargetKey, @JsonProperty(value="include_keys") List<String> includeKeys, @JsonProperty(value="exclude_keys") List<String> excludeKeys) {
            this(routes, tagsTargetKey, includeKeys, excludeKeys, new HashMap<String, Object>());
        }

        private SinkInternalJsonModel(List<String> routes, String tagsTargetKey, List<String> includeKeys, List<String> excludeKeys, Map<String, Object> pluginSettings) {
            super(pluginSettings);
            this.routes = routes != null ? routes : Collections.emptyList();
            this.includeKeys = includeKeys != null ? includeKeys : Collections.emptyList();
            this.excludeKeys = excludeKeys != null ? excludeKeys : Collections.emptyList();
            this.tagsTargetKey = tagsTargetKey;
            this.validateConfiguration();
            this.validateKeys();
        }

        void validateConfiguration() {
            if (!this.includeKeys.isEmpty() && !this.excludeKeys.isEmpty()) {
                throw new InvalidPluginConfigurationException("include_keys and exclude_keys cannot both exist in the configuration at the same time.");
            }
        }

        private void validateKeys() {
            this.includeKeys.forEach(key -> {
                if (key.contains("/")) {
                    throw new InvalidPluginConfigurationException("include_keys cannot contain /");
                }
            });
            this.excludeKeys.forEach(key -> {
                if (key.contains("/")) {
                    throw new InvalidPluginConfigurationException("exclude_keys cannot contain /");
                }
            });
        }
    }

    public static class SinkModelBuilder {
        private final PluginModel pluginModel;
        private final List<String> routes;
        private final String tagsTargetKey;
        private final List<String> includeKeys;
        private final List<String> excludeKeys;

        private SinkModelBuilder(PluginModel pluginModel) {
            this.pluginModel = pluginModel;
            this.routes = Collections.emptyList();
            this.tagsTargetKey = null;
            this.includeKeys = Collections.emptyList();
            this.excludeKeys = Collections.emptyList();
        }

        public SinkModel build() {
            return new SinkModel(this.pluginModel.getPluginName(), this.routes, this.tagsTargetKey, this.includeKeys, this.excludeKeys, this.pluginModel.getPluginSettings());
        }
    }
}

