/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.processor;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.pipeline.HeadlessPipeline;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;

public abstract class AbstractProcessor<InputRecord extends Record<?>, OutputRecord extends Record<?>>
implements Processor<InputRecord, OutputRecord> {
    protected final PluginMetrics pluginMetrics;
    private final Counter recordsInCounter;
    private final Counter recordsOutCounter;
    private final Timer timeElapsedTimer;
    private HeadlessPipeline failurePipeline;

    public AbstractProcessor(PluginSetting pluginSetting) {
        this.pluginMetrics = PluginMetrics.fromPluginSetting(pluginSetting);
        this.recordsInCounter = this.pluginMetrics.counter("recordsIn");
        this.recordsOutCounter = this.pluginMetrics.counter("recordsOut");
        this.timeElapsedTimer = this.pluginMetrics.timer("timeElapsed");
    }

    protected AbstractProcessor(PluginMetrics pluginMetrics) {
        this.pluginMetrics = pluginMetrics;
        this.recordsInCounter = pluginMetrics.counter("recordsIn");
        this.recordsOutCounter = pluginMetrics.counter("recordsOut");
        this.timeElapsedTimer = pluginMetrics.timer("timeElapsed");
    }

    @Override
    public Collection<OutputRecord> execute(Collection<InputRecord> records) {
        this.recordsInCounter.increment((double)records.size());
        Collection result = (Collection)this.timeElapsedTimer.record(() -> this.doExecute(records));
        this.recordsOutCounter.increment((double)result.size());
        return result;
    }

    public abstract Collection<OutputRecord> doExecute(Collection<InputRecord> var1);

    @Override
    public void setFailurePipeline(HeadlessPipeline failurePipeline) {
        this.failurePipeline = failurePipeline;
    }

    public HeadlessPipeline getFailurePipeline() {
        return this.failurePipeline;
    }
}

