/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum HandleFailedEventsOption {
    DROP("drop", true, true),
    DROP_SILENTLY("drop_silently", true, false),
    SKIP("skip", false, true),
    SKIP_SILENTLY("skip_silently", false, false);

    private static final Map<String, HandleFailedEventsOption> OPTIONS_MAP;
    private final String option;
    private final boolean isDropEventOption;
    private final boolean isLogRequired;

    private HandleFailedEventsOption(String option, boolean isDropEventOption, boolean isLogRequired) {
        this.option = option.toLowerCase();
        this.isDropEventOption = isDropEventOption;
        this.isLogRequired = isLogRequired;
    }

    public boolean shouldDropEvent() {
        return this.isDropEventOption;
    }

    public boolean shouldLog() {
        return this.isLogRequired;
    }

    @JsonCreator
    static HandleFailedEventsOption fromOptionValue(String option) {
        return OPTIONS_MAP.get(option.toLowerCase());
    }

    @JsonValue
    public String toOptionValue() {
        return this.option;
    }

    static {
        OPTIONS_MAP = Arrays.stream(HandleFailedEventsOption.values()).collect(Collectors.toMap(value -> value.option, value -> value));
    }
}

