/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.typeconverter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.opensearch.dataprepper.typeconverter.ConverterArguments;
import org.opensearch.dataprepper.typeconverter.TypeConverter;

public class BigDecimalConverter
implements TypeConverter<BigDecimal> {
    @Override
    public BigDecimal convert(Object source) throws IllegalArgumentException {
        return this.convert(source, 0);
    }

    @Override
    public BigDecimal convert(Object source, ConverterArguments arguments) throws IllegalArgumentException {
        return this.convert(source, arguments.getScale());
    }

    public BigDecimal convert(Object source, int scale) throws IllegalArgumentException {
        BigDecimal result = null;
        if (source instanceof String) {
            result = new BigDecimal((String)source);
        } else if (source instanceof Float) {
            result = BigDecimal.valueOf(((Float)source).floatValue());
        } else if (source instanceof Double) {
            result = BigDecimal.valueOf((Double)source);
        } else if (source instanceof Boolean) {
            result = (Boolean)source != false ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
        } else if (source instanceof Integer) {
            result = BigDecimal.valueOf(((Integer)source).intValue());
        } else if (source instanceof Long) {
            result = BigDecimal.valueOf((Long)source);
        } else if (source instanceof BigDecimal) {
            result = (BigDecimal)source;
        }
        if (result != null) {
            if (scale != 0) {
                result = result.setScale(scale, RoundingMode.HALF_EVEN);
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported type conversion. From Source class: " + String.valueOf(source.getClass()) + " to BigDecimal");
    }
}

