/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.trace;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.trace.DefaultLink;
import org.opensearch.dataprepper.model.trace.DefaultSpanEvent;
import org.opensearch.dataprepper.model.trace.DefaultTraceGroupFields;
import org.opensearch.dataprepper.model.trace.Link;
import org.opensearch.dataprepper.model.trace.Span;
import org.opensearch.dataprepper.model.trace.SpanEvent;
import org.opensearch.dataprepper.model.trace.TraceGroupFields;
import org.opensearch.dataprepper.model.validation.ParameterValidator;

public class JacksonSpan
extends JacksonEvent
implements Span {
    private static final String STATUS_KEY = "status";
    private static final String SCOPE_KEY = "instrumentationScope";
    private static final String RESOURCE_KEY = "resource";
    private static final String TRACE_ID_KEY = "traceId";
    private static final String SPAN_ID_KEY = "spanId";
    private static final String TRACE_STATE_KEY = "traceState";
    private static final String PARENT_SPAN_ID_KEY = "parentSpanId";
    private static final String NAME_KEY = "name";
    private static final String FLAGS_KEY = "flags";
    private static final String KIND_KEY = "kind";
    private static final String START_TIME_KEY = "startTime";
    private static final String END_TIME_KEY = "endTime";
    protected static final String ATTRIBUTES_KEY = "attributes";
    private static final String DROPPED_ATTRIBUTES_COUNT_KEY = "droppedAttributesCount";
    private static final String EVENTS_KEY = "events";
    private static final String SCHEMA_URL_KEY = "schemaUrl";
    private static final String DROPPED_EVENTS_COUNT_KEY = "droppedEventsCount";
    private static final String LINKS_KEY = "links";
    private static final String DROPPED_LINKS_COUNT_KEY = "droppedLinksCount";
    public static final String SERVICE_NAME_KEY = "serviceName";
    public static final String TRACE_GROUP_KEY = "traceGroup";
    private static final String DURATION_IN_NANOS_KEY = "durationInNanos";
    public static final String TRACE_GROUP_FIELDS_KEY = "traceGroupFields";
    private static final List<String> REQUIRED_KEYS = Arrays.asList("traceGroup");
    protected static final List<String> REQUIRED_NON_EMPTY_KEYS = Arrays.asList("traceId", "spanId", "name", "kind", "startTime", "endTime");
    private static final List<String> REQUIRED_NON_NULL_KEYS = Arrays.asList("durationInNanos", "traceGroupFields");
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    protected JacksonSpan(Builder builder) {
        super(builder);
        this.validateParameters();
        this.checkAndSetDefaultValues();
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals("TRACE"), (Object)"eventType must be of type Trace");
    }

    private JacksonSpan(JacksonSpan otherSpan) {
        super(otherSpan);
    }

    protected void validateParameters() {
        new ParameterValidator().validate(REQUIRED_KEYS, REQUIRED_NON_EMPTY_KEYS, REQUIRED_NON_NULL_KEYS, (HashMap)this.toMap());
    }

    protected void checkAndSetDefaultValues() {
        this.putIfAbsent(ATTRIBUTES_KEY, Map.class, new HashMap());
        this.putIfAbsent(DROPPED_ATTRIBUTES_COUNT_KEY, Integer.class, 0);
        this.putIfAbsent(LINKS_KEY, LinkedList.class, new LinkedList());
        this.putIfAbsent(DROPPED_LINKS_COUNT_KEY, Integer.class, 0);
        this.putIfAbsent(EVENTS_KEY, LinkedList.class, new LinkedList());
        this.putIfAbsent(DROPPED_EVENTS_COUNT_KEY, Integer.class, 0);
    }

    @Override
    public String getSchemaUrl() {
        return this.get(SCHEMA_URL_KEY, String.class);
    }

    @Override
    public String getTraceId() {
        return this.get(TRACE_ID_KEY, String.class);
    }

    @Override
    public String getSpanId() {
        return this.get(SPAN_ID_KEY, String.class);
    }

    @Override
    public String getTraceState() {
        return this.get(TRACE_STATE_KEY, String.class);
    }

    @Override
    public String getParentSpanId() {
        return this.get(PARENT_SPAN_ID_KEY, String.class);
    }

    @Override
    public String getName() {
        return this.get(NAME_KEY, String.class);
    }

    @Override
    public String getKind() {
        return this.get(KIND_KEY, String.class);
    }

    @Override
    public Integer getFlags() {
        return this.get(FLAGS_KEY, Integer.class);
    }

    @Override
    public Map<String, Object> getScope() {
        return this.get(SCOPE_KEY, Map.class);
    }

    @Override
    public Map<String, Object> getResource() {
        return this.get(RESOURCE_KEY, Map.class);
    }

    @Override
    public Map<String, Object> getStatus() {
        return this.get(STATUS_KEY, Map.class);
    }

    @Override
    public String getStartTime() {
        return this.get(START_TIME_KEY, String.class);
    }

    @Override
    public String getEndTime() {
        return this.get(END_TIME_KEY, String.class);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.get(ATTRIBUTES_KEY, Map.class);
    }

    @Override
    public Integer getDroppedAttributesCount() {
        return this.get(DROPPED_ATTRIBUTES_COUNT_KEY, Integer.class);
    }

    @Override
    public List<? extends SpanEvent> getEvents() {
        return this.getList(EVENTS_KEY, DefaultSpanEvent.class);
    }

    @Override
    public Integer getDroppedEventsCount() {
        return this.get(DROPPED_EVENTS_COUNT_KEY, Integer.class);
    }

    @Override
    public List<? extends Link> getLinks() {
        return this.getList(LINKS_KEY, DefaultLink.class);
    }

    @Override
    public Integer getDroppedLinksCount() {
        return this.get(DROPPED_LINKS_COUNT_KEY, Integer.class);
    }

    @Override
    public String getTraceGroup() {
        EventMetadata metadata = this.getMetadata();
        Object traceGroup = metadata.getAttribute(TRACE_GROUP_KEY);
        if (traceGroup != null) {
            return (String)traceGroup;
        }
        return this.get(TRACE_GROUP_KEY, String.class);
    }

    @Override
    public Long getDurationInNanos() {
        return this.get(DURATION_IN_NANOS_KEY, Long.class);
    }

    @Override
    public TraceGroupFields getTraceGroupFields() {
        EventMetadata metadata = this.getMetadata();
        Object traceGroupFields = metadata.getAttribute(TRACE_GROUP_FIELDS_KEY);
        if (traceGroupFields != null) {
            return (TraceGroupFields)traceGroupFields;
        }
        return this.get(TRACE_GROUP_FIELDS_KEY, DefaultTraceGroupFields.class);
    }

    @Override
    public String getServiceName() {
        EventMetadata metadata = this.getMetadata();
        Object serviceName = metadata.getAttribute(SERVICE_NAME_KEY);
        if (serviceName != null) {
            return (String)serviceName;
        }
        return this.get(SERVICE_NAME_KEY, String.class);
    }

    @Override
    public void setServiceName(String serviceName) {
        this.put(SERVICE_NAME_KEY, (Object)serviceName);
    }

    @Override
    public void setTraceGroup(String traceGroup) {
        this.put(TRACE_GROUP_KEY, (Object)traceGroup);
    }

    @Override
    public void setTraceGroupFields(TraceGroupFields traceGroupFields) {
        this.put(TRACE_GROUP_FIELDS_KEY, (Object)traceGroupFields);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JacksonSpan fromSpan(Span span) {
        if (span instanceof JacksonSpan) {
            return new JacksonSpan((JacksonSpan)span);
        }
        return JacksonSpan.builder().withData(span.toMap()).withEventMetadata(span.getMetadata()).build();
    }

    @Override
    public String toJsonString() {
        ObjectNode attributesNode = (ObjectNode)this.getJsonNode().get(ATTRIBUTES_KEY);
        ObjectNode flattenedJsonNode = (ObjectNode)this.getJsonNode().deepCopy();
        if (attributesNode != null) {
            flattenedJsonNode.remove(ATTRIBUTES_KEY);
            Iterator it = attributesNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String field = (String)entry.getKey();
                if (flattenedJsonNode.has(field)) continue;
                flattenedJsonNode.set(field, (JsonNode)entry.getValue());
            }
        }
        return flattenedJsonNode.toString();
    }

    public static class Builder
    extends JacksonEvent.Builder<Builder> {
        private final Map<String, Object> data = new HashMap<String, Object>();

        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withJsonData(String data) {
            try {
                this.data.putAll((Map)mapper.readValue(data, MAP_TYPE_REFERENCE));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("An exception occurred due to invalid JSON while converting data to event");
            }
            return this;
        }

        public Builder withData(Object data) {
            this.data.putAll((Map)mapper.convertValue(data, Map.class));
            return this;
        }

        public Builder withEventMetadata(EventMetadata eventMetadata) {
            super.withEventMetadata(eventMetadata);
            return this;
        }

        public Builder withSpanId(String spanId) {
            this.data.put(JacksonSpan.SPAN_ID_KEY, spanId);
            return this;
        }

        public Builder withTraceId(String traceId) {
            this.data.put(JacksonSpan.TRACE_ID_KEY, traceId);
            return this;
        }

        public Builder withTraceState(String traceState) {
            this.data.put(JacksonSpan.TRACE_STATE_KEY, traceState);
            return this;
        }

        public Builder withParentSpanId(String parentSpanId) {
            this.data.put(JacksonSpan.PARENT_SPAN_ID_KEY, parentSpanId);
            return this;
        }

        public Builder withName(String name) {
            this.data.put(JacksonSpan.NAME_KEY, name);
            return this;
        }

        public Builder withKind(String kind) {
            this.data.put(JacksonSpan.KIND_KEY, kind);
            return this;
        }

        public Builder withFlags(Integer flags) {
            this.data.put(JacksonSpan.FLAGS_KEY, flags);
            return this;
        }

        public Builder withSchemaUrl(String schemaUrl) {
            this.data.put(JacksonSpan.SCHEMA_URL_KEY, schemaUrl);
            return this;
        }

        public Builder withStatus(Map<String, Object> status) {
            this.data.put(JacksonSpan.STATUS_KEY, status);
            return this;
        }

        public Builder withScope(Map<String, Object> scope) {
            this.data.put(JacksonSpan.SCOPE_KEY, scope);
            return this.getThis();
        }

        public Builder withResource(Map<String, Object> resource) {
            this.data.put(JacksonSpan.RESOURCE_KEY, resource);
            return this.getThis();
        }

        public Builder withStartTime(String startTime) {
            this.data.put(JacksonSpan.START_TIME_KEY, startTime);
            return this;
        }

        public Builder withEndTime(String endTime) {
            this.data.put(JacksonSpan.END_TIME_KEY, endTime);
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            this.data.put(JacksonSpan.ATTRIBUTES_KEY, attributes);
            return this;
        }

        public Builder withDroppedAttributesCount(Integer droppedAttributesCount) {
            this.data.put(JacksonSpan.DROPPED_ATTRIBUTES_COUNT_KEY, droppedAttributesCount);
            return this;
        }

        public Builder withEvents(List<? extends SpanEvent> events) {
            this.data.put(JacksonSpan.EVENTS_KEY, events);
            return this;
        }

        public Builder withDroppedEventsCount(Integer droppedEventsCount) {
            this.data.put(JacksonSpan.DROPPED_EVENTS_COUNT_KEY, droppedEventsCount);
            return this;
        }

        public Builder withLinks(List<? extends Link> links) {
            this.data.put(JacksonSpan.LINKS_KEY, links);
            return this;
        }

        public Builder withDroppedLinksCount(Integer droppedLinksCount) {
            this.data.put(JacksonSpan.DROPPED_LINKS_COUNT_KEY, droppedLinksCount);
            return this;
        }

        public Builder withTraceGroup(String traceGroup) {
            this.data.put(JacksonSpan.TRACE_GROUP_KEY, traceGroup);
            return this;
        }

        public Builder withTimeReceived(Instant timeReceived) {
            return (Builder)super.withTimeReceived(timeReceived);
        }

        public Builder withDurationInNanos(Long durationInNanos) {
            this.data.put(JacksonSpan.DURATION_IN_NANOS_KEY, durationInNanos);
            return this;
        }

        public Builder withTraceGroupFields(TraceGroupFields traceGroupFields) {
            this.data.put(JacksonSpan.TRACE_GROUP_FIELDS_KEY, traceGroupFields);
            return this;
        }

        public Builder withServiceName(String serviceName) {
            this.data.put(JacksonSpan.SERVICE_NAME_KEY, serviceName);
            return this;
        }

        protected void populateEvent() {
            super.withData(this.data);
            this.withEventType(EventType.TRACE.toString());
        }

        @Override
        public JacksonSpan build() {
            this.populateEvent();
            return new JacksonSpan(this);
        }
    }
}

