/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.failures;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.model.event.EventHandle;

public class DlqObject {
    private static final String ISO8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.systemDefault());
    private final String pluginId;
    private final String pluginName;
    private final String pipelineName;
    private final Object failedData;
    private final String timestamp;
    @JsonIgnore
    private final EventHandle eventHandle;

    private DlqObject(String pluginId, String pluginName, String pipelineName, String timestamp, Object failedData, EventHandle eventHandle) {
        Preconditions.checkNotNull((Object)pluginId, (Object)"pluginId cannot be null");
        Preconditions.checkArgument((!pluginId.isEmpty() ? 1 : 0) != 0, (Object)"pluginId cannot be an empty string");
        Preconditions.checkNotNull((Object)pluginName, (Object)"pluginName cannot be null");
        Preconditions.checkArgument((!pluginName.isEmpty() ? 1 : 0) != 0, (Object)"pluginName cannot be an empty string");
        Preconditions.checkNotNull((Object)pipelineName, (Object)"pipelineName cannot be null");
        Preconditions.checkArgument((!pipelineName.isEmpty() ? 1 : 0) != 0, (Object)"pipelineName cannot be an empty string");
        Preconditions.checkNotNull((Object)failedData, (Object)"failedData cannot be null");
        this.pluginId = pluginId;
        this.pluginName = pluginName;
        this.pipelineName = pipelineName;
        this.failedData = failedData;
        this.eventHandle = eventHandle;
        this.timestamp = StringUtils.isEmpty((CharSequence)timestamp) ? FORMATTER.format(Instant.now()) : timestamp;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public Object getFailedData() {
        return this.failedData;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public EventHandle getEventHandle() {
        return this.eventHandle;
    }

    public void releaseEventHandle(boolean result) {
        if (this.eventHandle != null) {
            this.eventHandle.release(result);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DlqObject that = (DlqObject)o;
        return Objects.equals(this.failedData, that.getFailedData()) && Objects.equals(this.pluginId, that.pluginId) && Objects.equals(this.pluginName, that.pluginName) && Objects.equals(this.pipelineName, that.pipelineName) && Objects.equals(this.eventHandle, that.eventHandle) && Objects.equals(this.timestamp, that.getTimestamp());
    }

    public int hashCode() {
        return Objects.hash(this.pluginId, this.pluginName, this.pipelineName, this.timestamp, this.failedData);
    }

    public String toString() {
        return "DlqObject{pluginId='" + this.pluginId + "', pluginName='" + this.pluginName + "', pipelineName='" + this.pipelineName + "', timestamp='" + this.timestamp + "', failedData=" + String.valueOf(this.failedData) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pluginId;
        private String pluginName;
        private String pipelineName;
        private Object failedData;
        private EventHandle eventHandle;
        private String timestamp;

        public Builder withPluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public Builder withPluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder withPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public Builder withFailedData(Object failedData) {
            this.failedData = failedData;
            return this;
        }

        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withEventHandle(EventHandle eventHandle) {
            this.eventHandle = eventHandle;
            return this;
        }

        public Builder withTimestamp(Instant instant) {
            this.timestamp = FORMATTER.format(instant);
            return this;
        }

        public DlqObject build() {
            return new DlqObject(this.pluginId, this.pluginName, this.pipelineName, this.timestamp, this.failedData, this.eventHandle);
        }
    }
}

