/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.typeconverter;

import java.math.BigDecimal;
import org.opensearch.dataprepper.typeconverter.ConverterArguments;
import org.opensearch.dataprepper.typeconverter.TypeConverter;

public class LongConverter
implements TypeConverter<Long> {
    @Override
    public Long convert(Object source, ConverterArguments arguments) throws IllegalArgumentException {
        return this.convert(source);
    }

    @Override
    public Long convert(Object source) throws IllegalArgumentException {
        if (source instanceof String) {
            return Long.parseLong((String)source);
        }
        if (source instanceof Float) {
            return (long)((Float)source).floatValue();
        }
        if (source instanceof Double) {
            return (long)((Double)source).doubleValue();
        }
        if (source instanceof Boolean) {
            return (Boolean)source != false ? 1L : 0L;
        }
        if (source instanceof Integer) {
            return ((Integer)source).longValue();
        }
        if (source instanceof Long) {
            return (Long)source;
        }
        if (source instanceof BigDecimal) {
            return ((BigDecimal)source).longValue();
        }
        throw new IllegalArgumentException("Unsupported type conversion. Source class: " + source.getClass());
    }
}

