/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.configuration;

import com.amazon.dataprepper.model.configuration.PluginModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineModel {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineModel.class);
    @JsonProperty(value="source")
    private final PluginModel source;
    @JsonProperty(value="processor")
    private final List<PluginModel> processors;
    @JsonProperty(value="sink")
    private final List<PluginModel> sinks;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer workers;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer readBatchDelay;

    private static List<PluginModel> validateProcessor(List<PluginModel> preppers, List<PluginModel> processors) {
        if (preppers != null) {
            LOG.warn("Prepper configurations are deprecated, processor configurations will be required in Data Prepper 2.0");
        }
        if (preppers != null && processors != null) {
            String message = "Pipeline model cannot specify a prepper and processor configuration. It is recommended to move prepper configurations to the processor section to maintain compatibility with DataPrepper version 1.2 and above.";
            throw new IllegalArgumentException("Pipeline model cannot specify a prepper and processor configuration. It is recommended to move prepper configurations to the processor section to maintain compatibility with DataPrepper version 1.2 and above.");
        }
        if (preppers != null) {
            return preppers;
        }
        return processors;
    }

    public PipelineModel(PluginModel source, List<PluginModel> processors, List<PluginModel> sinks, Integer workers, Integer delay) {
        this.source = source;
        this.processors = processors;
        this.sinks = sinks;
        this.workers = workers;
        this.readBatchDelay = delay;
    }

    @JsonCreator
    @Deprecated
    public PipelineModel(@JsonProperty(value="source") PluginModel source, @Deprecated @JsonProperty(value="prepper") List<PluginModel> preppers, @JsonProperty(value="processor") List<PluginModel> processors, @JsonProperty(value="sink") List<PluginModel> sinks, @JsonProperty(value="workers") Integer workers, @JsonProperty(value="delay") Integer delay) {
        this(source, PipelineModel.validateProcessor(preppers, processors), sinks, workers, delay);
    }

    public PluginModel getSource() {
        return this.source;
    }

    @Deprecated
    @JsonIgnore
    public List<PluginModel> getPreppers() {
        return this.processors;
    }

    public List<PluginModel> getProcessors() {
        return this.processors;
    }

    public List<PluginModel> getSinks() {
        return this.sinks;
    }

    public Integer getWorkers() {
        return this.workers;
    }

    public Integer getReadBatchDelay() {
        return this.readBatchDelay;
    }
}

