/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.metric;

import com.amazon.dataprepper.model.event.EventType;
import com.amazon.dataprepper.model.metric.Gauge;
import com.amazon.dataprepper.model.metric.JacksonMetric;
import com.amazon.dataprepper.model.metric.Metric;
import com.amazon.dataprepper.model.metric.ParameterValidator;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class JacksonGauge
extends JacksonMetric
implements Gauge {
    private static final String VALUE_KEY = "value";
    private static final List<String> REQUIRED_KEYS = new ArrayList<String>();
    private static final List<String> REQUIRED_NON_EMPTY_KEYS = Arrays.asList("name", "kind", "time");
    private static final List<String> REQUIRED_NON_NULL_KEYS = Collections.singletonList("value");

    protected JacksonGauge(Builder builder) {
        super(builder);
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals(EventType.METRIC.toString()), (Object)"eventType must be of type Metric");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Double getValue() {
        return this.get(VALUE_KEY, Double.class);
    }

    public static class Builder
    extends JacksonMetric.Builder<Builder> {
        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withValue(Double value) {
            if (value != null) {
                this.data.put(JacksonGauge.VALUE_KEY, value);
            }
            return this;
        }

        @Override
        public JacksonGauge build() {
            this.withEventKind(Metric.KIND.GAUGE.toString());
            this.withData(this.data);
            this.withEventType(EventType.METRIC.toString());
            this.checkAndSetDefaultValues();
            new ParameterValidator().validate(REQUIRED_KEYS, REQUIRED_NON_EMPTY_KEYS, REQUIRED_NON_NULL_KEYS, this.data);
            return new JacksonGauge(this);
        }

        private void checkAndSetDefaultValues() {
            this.data.computeIfAbsent("attributes", k -> new HashMap());
        }
    }
}

