/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.data.client.orhlc.ClientConfiguration;
import org.springframework.data.elasticsearch.support.HttpHeaders;
import org.springframework.util.Assert;

public final class RestClients {
    private RestClients() {
    }

    public static OpenSearchRestClient create(ClientConfiguration clientConfiguration) {
        HttpHeaders headers;
        Assert.notNull((Object)clientConfiguration, (String)"ClientConfiguration must not be null!");
        HttpHost[] httpHosts = (HttpHost[])RestClients.formattedHosts(clientConfiguration.getEndpoints(), clientConfiguration.useSsl()).stream().map(s -> {
            try {
                return HttpHost.create((String)s);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if (clientConfiguration.getPathPrefix() != null) {
            builder.setPathPrefix(clientConfiguration.getPathPrefix());
        }
        if (!(headers = clientConfiguration.getDefaultHeaders()).isEmpty()) {
            builder.setDefaultHeaders(RestClients.toHeaderArray(headers));
        }
        builder.setHttpClientConfigCallback(clientBuilder -> {
            Duration socketTimeout;
            ClientTlsStrategyBuilder tlsStrategy = ClientTlsStrategyBuilder.create();
            clientConfiguration.getSslContext().ifPresent(arg_0 -> ((ClientTlsStrategyBuilder)tlsStrategy).setSslContext(arg_0));
            clientConfiguration.getHostNameVerifier().ifPresent(arg_0 -> ((ClientTlsStrategyBuilder)tlsStrategy).setHostnameVerifier(arg_0));
            clientBuilder.addRequestInterceptorLast((HttpRequestInterceptor)new CustomHeaderInjector(clientConfiguration.getHeadersSupplier()));
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            Duration connectTimeout = clientConfiguration.getConnectTimeout();
            if (!connectTimeout.isNegative()) {
                requestConfigBuilder.setConnectTimeout(Timeout.ofMilliseconds((long)connectTimeout.toMillis()));
            }
            if (!(socketTimeout = clientConfiguration.getSocketTimeout()).isNegative()) {
                requestConfigBuilder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)socketTimeout.toMillis()));
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            clientConfiguration.getProxy().map(s -> {
                try {
                    return HttpHost.create((String)s);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setProxy(arg_0));
            for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurer : clientConfiguration.getClientConfigurers()) {
                if (!(clientConfigurer instanceof RestClientConfigurationCallback)) continue;
                RestClientConfigurationCallback restClientConfigurationCallback = (RestClientConfigurationCallback)clientConfigurer;
                clientBuilder = restClientConfigurationCallback.configure(clientBuilder);
            }
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy.build()).build();
            return clientBuilder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
        });
        RestHighLevelClient client = new RestHighLevelClient(builder);
        return () -> client;
    }

    private static Header[] toHeaderArray(HttpHeaders headers) {
        return (Header[])headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new BasicHeader((String)entry.getKey(), value))).toArray(Header[]::new);
    }

    private static List<String> formattedHosts(List<InetSocketAddress> hosts, boolean useSsl) {
        return hosts.stream().map(it -> (useSsl ? "https" : "http") + "://" + it.getHostString() + ":" + it.getPort()).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface OpenSearchRestClient
    extends Closeable {
        public RestHighLevelClient rest();

        default public RestClient lowLevelRest() {
            return this.rest().getLowLevelClient();
        }

        @Override
        default public void close() throws IOException {
            this.rest().close();
        }
    }

    private static class CustomHeaderInjector
    implements HttpRequestInterceptor {
        private final Supplier<HttpHeaders> headersSupplier;

        public CustomHeaderInjector(Supplier<HttpHeaders> headersSupplier) {
            this.headersSupplier = headersSupplier;
        }

        public void process(HttpRequest request, EntityDetails entity, HttpContext context) {
            HttpHeaders httpHeaders = this.headersSupplier.get();
            if (httpHeaders != null && !httpHeaders.isEmpty()) {
                Arrays.stream(RestClients.toHeaderArray(httpHeaders)).forEach(arg_0 -> ((HttpRequest)request).addHeader(arg_0));
            }
        }
    }

    public static interface RestClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<HttpAsyncClientBuilder> {
        public static RestClientConfigurationCallback from(Function<HttpAsyncClientBuilder, HttpAsyncClientBuilder> clientBuilderCallback) {
            Assert.notNull(clientBuilderCallback, (String)"clientBuilderCallback must not be null");
            return clientBuilderCallback::apply;
        }
    }
}

