/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.lucene.search.Explanation;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.common.document.DocumentField;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.text.Text;
import org.opensearch.data.client.orhlc.ResponseConverter;
import org.opensearch.data.client.orhlc.SearchDocumentResponseBuilder;
import org.opensearch.index.get.GetResult;
import org.opensearch.search.SearchHit;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.mapping.MappingException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class DocumentAdapters {
    private DocumentAdapters() {
    }

    @Nullable
    public static Document from(GetResponse getResponse) {
        Assert.notNull((Object)getResponse, (String)"GetResponse must not be null");
        if (!getResponse.isExists()) {
            return null;
        }
        if (getResponse.isSourceEmpty()) {
            return DocumentAdapters.fromDocumentFields((Iterable<DocumentField>)getResponse, getResponse.getIndex(), getResponse.getId(), getResponse.getVersion(), getResponse.getSeqNo(), getResponse.getPrimaryTerm());
        }
        Document document = Document.from((Map)getResponse.getSourceAsMap());
        document.setIndex(getResponse.getIndex());
        document.setId(getResponse.getId());
        document.setVersion(getResponse.getVersion());
        document.setSeqNo(getResponse.getSeqNo());
        document.setPrimaryTerm(getResponse.getPrimaryTerm());
        return document;
    }

    @Nullable
    public static Document from(GetResult source) {
        Assert.notNull((Object)source, (String)"GetResult must not be null");
        if (!source.isExists()) {
            return null;
        }
        if (source.isSourceEmpty()) {
            return DocumentAdapters.fromDocumentFields((Iterable<DocumentField>)source, source.getIndex(), source.getId(), source.getVersion(), source.getSeqNo(), source.getPrimaryTerm());
        }
        Document document = Document.from((Map)source.getSource());
        document.setIndex(source.getIndex());
        document.setId(source.getId());
        document.setVersion(source.getVersion());
        document.setSeqNo(source.getSeqNo());
        document.setPrimaryTerm(source.getPrimaryTerm());
        return document;
    }

    public static List<MultiGetItem<Document>> from(MultiGetResponse source) {
        Assert.notNull((Object)source, (String)"MultiGetResponse must not be null");
        return Arrays.stream(source.getResponses()).map(DocumentAdapters::from).collect(Collectors.toList());
    }

    public static MultiGetItem<Document> from(MultiGetItemResponse itemResponse) {
        MultiGetItem.Failure failure = ResponseConverter.getFailure(itemResponse);
        return MultiGetItem.of((Object)(itemResponse.isFailed() ? null : DocumentAdapters.from(itemResponse.getResponse())), (MultiGetItem.Failure)failure);
    }

    public static SearchDocument from(SearchHit source) {
        Assert.notNull((Object)source, (String)"SearchHit must not be null");
        HashMap<String, List<String>> highlightFields = new HashMap<String, List<String>>(source.getHighlightFields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.stream(((HighlightField)entry.getValue()).getFragments()).map(Text::string).collect(Collectors.toList()))));
        LinkedHashMap<String, SearchDocumentResponse> innerHits = new LinkedHashMap<String, SearchDocumentResponse>();
        Map sourceInnerHits = source.getInnerHits();
        if (sourceInnerHits != null) {
            sourceInnerHits.forEach((name, searchHits) -> innerHits.put((String)name, SearchDocumentResponseBuilder.from(searchHits, null, null, 0L, null, null, searchDocument -> CompletableFuture.completedFuture(null))));
        }
        NestedMetaData nestedMetaData = DocumentAdapters.from(source.getNestedIdentity());
        org.springframework.data.elasticsearch.core.document.Explanation explanation = DocumentAdapters.from(source.getExplanation());
        List<String> matchedQueries = DocumentAdapters.from(source.getMatchedQueries());
        BytesReference sourceRef = source.getSourceRef();
        Map sourceFields = source.getFields();
        if (sourceRef == null || sourceRef.length() == 0) {
            return new SearchDocumentAdapter(DocumentAdapters.fromDocumentFields((Iterable<DocumentField>)source, source.getIndex(), source.getId(), source.getVersion(), source.getSeqNo(), source.getPrimaryTerm()), source.getScore(), source.getSortValues(), sourceFields, highlightFields, innerHits, nestedMetaData, explanation, matchedQueries);
        }
        Document document = Document.from((Map)source.getSourceAsMap());
        document.setIndex(source.getIndex());
        document.setId(source.getId());
        if (source.getVersion() >= 0L) {
            document.setVersion(source.getVersion());
        }
        document.setSeqNo(source.getSeqNo());
        document.setPrimaryTerm(source.getPrimaryTerm());
        return new SearchDocumentAdapter(document, source.getScore(), source.getSortValues(), sourceFields, highlightFields, innerHits, nestedMetaData, explanation, matchedQueries);
    }

    @Nullable
    private static org.springframework.data.elasticsearch.core.document.Explanation from(@Nullable Explanation explanation) {
        if (explanation == null) {
            return null;
        }
        ArrayList<org.springframework.data.elasticsearch.core.document.Explanation> details = new ArrayList<org.springframework.data.elasticsearch.core.document.Explanation>();
        for (Explanation detail : explanation.getDetails()) {
            details.add(DocumentAdapters.from(detail));
        }
        return new org.springframework.data.elasticsearch.core.document.Explanation(Boolean.valueOf(explanation.isMatch()), Double.valueOf(explanation.getValue().doubleValue()), explanation.getDescription(), details);
    }

    @Nullable
    private static NestedMetaData from(@Nullable SearchHit.NestedIdentity nestedIdentity) {
        if (nestedIdentity == null) {
            return null;
        }
        NestedMetaData child = DocumentAdapters.from(nestedIdentity.getChild());
        return NestedMetaData.of((String)nestedIdentity.getField().string(), (int)nestedIdentity.getOffset(), (NestedMetaData)child);
    }

    @Nullable
    private static List<String> from(@Nullable String[] matchedQueries) {
        return matchedQueries == null ? null : Arrays.asList(matchedQueries);
    }

    public static Document fromDocumentFields(Iterable<DocumentField> documentFields, String index, String id, long version, long seqNo, long primaryTerm) {
        if (documentFields instanceof Collection) {
            return new DocumentFieldAdapter((Collection)documentFields, index, id, version, seqNo, primaryTerm);
        }
        ArrayList<DocumentField> fields = new ArrayList<DocumentField>();
        for (DocumentField documentField : documentFields) {
            fields.add(documentField);
        }
        return new DocumentFieldAdapter(fields, index, id, version, seqNo, primaryTerm);
    }

    static class SearchDocumentAdapter
    implements SearchDocument {
        private final float score;
        private final Object[] sortValues;
        private final Map<String, List<Object>> fields = new HashMap<String, List<Object>>();
        private final Document delegate;
        private final Map<String, List<String>> highlightFields = new HashMap<String, List<String>>();
        private final Map<String, SearchDocumentResponse> innerHits = new HashMap<String, SearchDocumentResponse>();
        @Nullable
        private final NestedMetaData nestedMetaData;
        @Nullable
        private final org.springframework.data.elasticsearch.core.document.Explanation explanation;
        @Nullable
        private final List<String> matchedQueries;

        SearchDocumentAdapter(Document delegate, float score, Object[] sortValues, Map<String, DocumentField> fields, Map<String, List<String>> highlightFields, Map<String, SearchDocumentResponse> innerHits, @Nullable NestedMetaData nestedMetaData, @Nullable org.springframework.data.elasticsearch.core.document.Explanation explanation, @Nullable List<String> matchedQueries) {
            this.delegate = delegate;
            this.score = score;
            this.sortValues = sortValues;
            fields.forEach((? super K name, ? super V documentField) -> this.fields.put((String)name, documentField.getValues()));
            this.highlightFields.putAll(highlightFields);
            this.innerHits.putAll(innerHits);
            this.nestedMetaData = nestedMetaData;
            this.explanation = explanation;
            this.matchedQueries = matchedQueries;
        }

        public SearchDocument append(String key, Object value) {
            this.delegate.append(key, value);
            return this;
        }

        public float getScore() {
            return this.score;
        }

        public Map<String, List<Object>> getFields() {
            return this.fields;
        }

        public Object[] getSortValues() {
            return this.sortValues;
        }

        public Map<String, List<String>> getHighlightFields() {
            return this.highlightFields;
        }

        public String getIndex() {
            return this.delegate.getIndex();
        }

        public boolean hasId() {
            return this.delegate.hasId();
        }

        public String getId() {
            return this.delegate.getId();
        }

        public void setId(String id) {
            this.delegate.setId(id);
        }

        public boolean hasVersion() {
            return this.delegate.hasVersion();
        }

        public long getVersion() {
            return this.delegate.getVersion();
        }

        public void setVersion(long version) {
            this.delegate.setVersion(version);
        }

        public boolean hasSeqNo() {
            return this.delegate.hasSeqNo();
        }

        public long getSeqNo() {
            return this.delegate.getSeqNo();
        }

        public void setSeqNo(long seqNo) {
            this.delegate.setSeqNo(seqNo);
        }

        public boolean hasPrimaryTerm() {
            return this.delegate.hasPrimaryTerm();
        }

        public long getPrimaryTerm() {
            return this.delegate.getPrimaryTerm();
        }

        public void setPrimaryTerm(long primaryTerm) {
            this.delegate.setPrimaryTerm(primaryTerm);
        }

        public Map<String, SearchDocumentResponse> getInnerHits() {
            return this.innerHits;
        }

        @Nullable
        public NestedMetaData getNestedMetaData() {
            return this.nestedMetaData;
        }

        @Nullable
        public <T> T get(Object key, Class<T> type) {
            return (T)this.delegate.get(key, type);
        }

        public String toJson() {
            return this.delegate.toJson();
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        public Object get(Object key) {
            if (this.delegate.containsKey(key)) {
                return this.delegate.get(key);
            }
            return this.fields.get(key);
        }

        public Object put(String key, Object value) {
            return this.delegate.put((Object)key, value);
        }

        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        public void putAll(Map<? extends String, ?> m) {
            this.delegate.putAll(m);
        }

        public void clear() {
            this.delegate.clear();
        }

        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        public Collection<Object> values() {
            return this.delegate.values();
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        @Nullable
        public org.springframework.data.elasticsearch.core.document.Explanation getExplanation() {
            return this.explanation;
        }

        @Nullable
        public List<String> getMatchedQueries() {
            return this.matchedQueries;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SearchDocumentAdapter)) {
                return false;
            }
            SearchDocumentAdapter that = (SearchDocumentAdapter)o;
            return Float.compare(that.score, this.score) == 0 && this.delegate.equals((Object)that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void forEach(BiConsumer<? super String, ? super Object> action) {
            this.delegate.forEach(action);
        }

        public boolean remove(Object key, Object value) {
            return this.delegate.remove(key, value);
        }

        public String toString() {
            String id = this.hasId() ? this.getId() : "?";
            String version = this.hasVersion() ? Long.toString(this.getVersion()) : "?";
            return this.getClass().getSimpleName() + "@" + id + "#" + version + " " + this.toJson();
        }
    }

    static class DocumentFieldAdapter
    implements Document {
        private final Collection<DocumentField> documentFields;
        private final Map<String, DocumentField> documentFieldMap;
        private final String index;
        private final String id;
        private final long version;
        private final long seqNo;
        private final long primaryTerm;

        DocumentFieldAdapter(Collection<DocumentField> documentFields, String index, String id, long version, long seqNo, long primaryTerm) {
            this.documentFields = documentFields;
            this.documentFieldMap = new LinkedHashMap<String, DocumentField>(documentFields.size());
            documentFields.forEach((? super T documentField) -> this.documentFieldMap.put(documentField.getName(), (DocumentField)documentField));
            this.index = index;
            this.id = id;
            this.version = version;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
        }

        public String getIndex() {
            return this.index;
        }

        public boolean hasId() {
            return StringUtils.hasLength((String)this.id);
        }

        public String getId() {
            return this.id;
        }

        public boolean hasVersion() {
            return this.version >= 0L;
        }

        public long getVersion() {
            if (!this.hasVersion()) {
                throw new IllegalStateException("No version associated with this Document");
            }
            return this.version;
        }

        public boolean hasSeqNo() {
            return true;
        }

        public long getSeqNo() {
            if (!this.hasSeqNo()) {
                throw new IllegalStateException("No seq_no associated with this Document");
            }
            return this.seqNo;
        }

        public boolean hasPrimaryTerm() {
            return true;
        }

        public long getPrimaryTerm() {
            if (!this.hasPrimaryTerm()) {
                throw new IllegalStateException("No primary_term associated with this Document");
            }
            return this.primaryTerm;
        }

        public int size() {
            return this.documentFields.size();
        }

        public boolean isEmpty() {
            return this.documentFields.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.documentFieldMap.containsKey(key);
        }

        public boolean containsValue(Object value) {
            for (DocumentField documentField : this.documentFields) {
                Object fieldValue = DocumentFieldAdapter.getValue(documentField);
                if ((fieldValue == null || !fieldValue.equals(value)) && value != fieldValue) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public Object get(Object key) {
            DocumentField documentField = this.documentFieldMap.get(key);
            return documentField != null ? documentField.getValue() : null;
        }

        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set<String> keySet() {
            return this.documentFieldMap.keySet();
        }

        public Collection<Object> values() {
            return this.documentFieldMap.values().stream().map(DocumentFieldAdapter::getValue).collect(Collectors.toList());
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            return this.documentFieldMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DocumentFieldAdapter.getValue((DocumentField)entry.getValue()))).entrySet();
        }

        public void forEach(BiConsumer<? super String, ? super Object> action) {
            Objects.requireNonNull(action);
            this.documentFields.forEach((? super T field) -> action.accept(field.getName(), DocumentFieldAdapter.getValue(field)));
        }

        public String toJson() {
            JsonFactory nodeFactory = new JsonFactory();
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                JsonGenerator generator = nodeFactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
                generator.writeStartObject();
                for (DocumentField value : this.documentFields) {
                    if (value.getValues().size() > 1) {
                        generator.writeArrayFieldStart(value.getName());
                        for (Object val : value.getValues()) {
                            generator.writeObject(val);
                        }
                        generator.writeEndArray();
                        continue;
                    }
                    generator.writeObjectField(value.getName(), value.getValue());
                }
                generator.writeEndObject();
                generator.flush();
                return new String(stream.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new MappingException("Cannot render JSON", (Throwable)e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.id + "#" + this.version + " " + this.toJson();
        }

        @Nullable
        private static Object getValue(DocumentField documentField) {
            if (documentField.getValues().isEmpty()) {
                return null;
            }
            if (documentField.getValues().size() == 1) {
                return documentField.getValue();
            }
            return documentField.getValues();
        }
    }
}

