/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.data.client.orhlc.ClientConfiguration;
import org.springframework.data.elasticsearch.support.HttpHeaders;
import org.springframework.util.Assert;

public final class RestClients {
    private RestClients() {
    }

    public static OpenSearchRestClient create(ClientConfiguration clientConfiguration) {
        HttpHeaders headers;
        Assert.notNull((Object)clientConfiguration, (String)"ClientConfiguration must not be null!");
        HttpHost[] httpHosts = (HttpHost[])RestClients.formattedHosts(clientConfiguration.getEndpoints(), clientConfiguration.useSsl()).stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if (clientConfiguration.getPathPrefix() != null) {
            builder.setPathPrefix(clientConfiguration.getPathPrefix());
        }
        if (!(headers = clientConfiguration.getDefaultHeaders()).isEmpty()) {
            builder.setDefaultHeaders(RestClients.toHeaderArray(headers));
        }
        builder.setHttpClientConfigCallback(clientBuilder -> {
            Duration socketTimeout;
            clientConfiguration.getSslContext().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLContext(arg_0));
            clientConfiguration.getHostNameVerifier().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLHostnameVerifier(arg_0));
            clientBuilder.addInterceptorLast((HttpRequestInterceptor)new CustomHeaderInjector(clientConfiguration.getHeadersSupplier()));
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            Duration connectTimeout = clientConfiguration.getConnectTimeout();
            if (!connectTimeout.isNegative()) {
                requestConfigBuilder.setConnectTimeout(Math.toIntExact(connectTimeout.toMillis()));
            }
            if (!(socketTimeout = clientConfiguration.getSocketTimeout()).isNegative()) {
                requestConfigBuilder.setSocketTimeout(Math.toIntExact(socketTimeout.toMillis()));
                requestConfigBuilder.setConnectionRequestTimeout(Math.toIntExact(socketTimeout.toMillis()));
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            clientConfiguration.getProxy().map(HttpHost::create).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setProxy(arg_0));
            for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurer : clientConfiguration.getClientConfigurers()) {
                if (!(clientConfigurer instanceof RestClientConfigurationCallback)) continue;
                RestClientConfigurationCallback restClientConfigurationCallback = (RestClientConfigurationCallback)clientConfigurer;
                clientBuilder = restClientConfigurationCallback.configure(clientBuilder);
            }
            return clientBuilder;
        });
        RestHighLevelClient client = new RestHighLevelClient(builder);
        return () -> client;
    }

    private static Header[] toHeaderArray(HttpHeaders headers) {
        return (Header[])headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new BasicHeader((String)entry.getKey(), value))).toArray(Header[]::new);
    }

    private static List<String> formattedHosts(List<InetSocketAddress> hosts, boolean useSsl) {
        return hosts.stream().map(it -> (useSsl ? "https" : "http") + "://" + it.getHostString() + ":" + it.getPort()).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface OpenSearchRestClient
    extends Closeable {
        public RestHighLevelClient rest();

        default public RestClient lowLevelRest() {
            return this.rest().getLowLevelClient();
        }

        @Override
        default public void close() throws IOException {
            this.rest().close();
        }
    }

    private static class CustomHeaderInjector
    implements HttpRequestInterceptor {
        private final Supplier<HttpHeaders> headersSupplier;

        public CustomHeaderInjector(Supplier<HttpHeaders> headersSupplier) {
            this.headersSupplier = headersSupplier;
        }

        public void process(HttpRequest request, HttpContext context) {
            HttpHeaders httpHeaders = this.headersSupplier.get();
            if (httpHeaders != null && !httpHeaders.isEmpty()) {
                Arrays.stream(RestClients.toHeaderArray(httpHeaders)).forEach(arg_0 -> ((HttpRequest)request).addHeader(arg_0));
            }
        }
    }

    public static interface RestClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<HttpAsyncClientBuilder> {
        public static RestClientConfigurationCallback from(Function<HttpAsyncClientBuilder, HttpAsyncClientBuilder> clientBuilderCallback) {
            Assert.notNull(clientBuilderCallback, (String)"clientBuilderCallback must not be null");
            return clientBuilderCallback::apply;
        }
    }
}

