/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.KnnQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch.core.search.FieldCollapse;
import org.opensearch.client.opensearch.core.search.Suggester;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.data.client.osc.NativeQuery;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class NativeQueryBuilder
extends BaseQueryBuilder<NativeQuery, NativeQueryBuilder> {
    @Nullable
    private Query query;
    @Nullable
    private Query filter;
    private final Map<String, Aggregation> aggregations = new LinkedHashMap<String, Aggregation>();
    @Nullable
    private Suggester suggester;
    @Nullable
    private FieldCollapse fieldCollapse;
    private List<SortOptions> sortOptions = new ArrayList<SortOptions>();
    private Map<String, JsonData> searchExtensions = new LinkedHashMap<String, JsonData>();
    @Nullable
    private org.springframework.data.elasticsearch.core.query.Query springDataQuery;
    @Nullable
    private KnnQuery knnQuery;

    @Nullable
    public Query getQuery() {
        return this.query;
    }

    @Nullable
    public Query getFilter() {
        return this.filter;
    }

    public Map<String, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public Suggester getSuggester() {
        return this.suggester;
    }

    @Nullable
    public FieldCollapse getFieldCollapse() {
        return this.fieldCollapse;
    }

    public List<SortOptions> getSortOptions() {
        return this.sortOptions;
    }

    public Map<String, JsonData> getSearchExtensions() {
        return this.searchExtensions;
    }

    @Nullable
    public KnnQuery getKnnQuery() {
        return this.knnQuery;
    }

    @Nullable
    public org.springframework.data.elasticsearch.core.query.Query getSpringDataQuery() {
        return this.springDataQuery;
    }

    public NativeQueryBuilder withQuery(QueryVariant variant) {
        Assert.notNull((Object)variant, (String)"query variant must not be null");
        this.query = variant.toQuery();
        return this;
    }

    public NativeQueryBuilder withQuery(ObjectBuilder<? extends QueryVariant> builder) {
        Assert.notNull(builder, (String)"builder must not be null");
        this.query = ((QueryVariant)builder.build()).toQuery();
        return this;
    }

    public NativeQueryBuilder withQuery(Query query) {
        Assert.notNull((Object)query, (String)"query must not be null");
        this.query = query;
        return this;
    }

    public NativeQueryBuilder withQuery(Function<Query.Builder, ObjectBuilder<Query>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.withQuery((Query)fn.apply(new Query.Builder()).build());
    }

    public NativeQueryBuilder withFilter(@Nullable Query filter) {
        this.filter = filter;
        return this;
    }

    public NativeQueryBuilder withFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.withFilter((Query)fn.apply(new Query.Builder()).build());
    }

    public NativeQueryBuilder withAggregation(String name, Aggregation aggregation) {
        Assert.notNull((Object)name, (String)"name must not be null");
        Assert.notNull((Object)aggregation, (String)"aggregation must not be null");
        this.aggregations.put(name, aggregation);
        return this;
    }

    public NativeQueryBuilder withSuggester(@Nullable Suggester suggester) {
        this.suggester = suggester;
        return this;
    }

    public NativeQueryBuilder withFieldCollapse(@Nullable FieldCollapse fieldCollapse) {
        this.fieldCollapse = fieldCollapse;
        return this;
    }

    public NativeQueryBuilder withSort(List<SortOptions> values) {
        Assert.notEmpty(values, (String)"values must not be empty");
        this.sortOptions.clear();
        this.sortOptions.addAll(values);
        return this;
    }

    public NativeQueryBuilder withSort(SortOptions value, SortOptions ... values) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.sortOptions.add(value);
        if (values.length > 0) {
            this.sortOptions.addAll(Arrays.asList(values));
        }
        return this;
    }

    public NativeQueryBuilder withSort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        this.withSort((SortOptions)fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        return this;
    }

    public NativeQueryBuilder withSearchExtension(String key, JsonData value) {
        Assert.notNull((Object)key, (String)"key must not be null");
        Assert.notNull((Object)value, (String)"value must not be null");
        this.searchExtensions.put(key, value);
        return this;
    }

    public NativeQueryBuilder withSearchExtensions(Map<String, JsonData> searchExtensions) {
        Assert.notNull(searchExtensions, (String)"searchExtensions must not be null");
        this.searchExtensions.putAll(searchExtensions);
        return this;
    }

    public NativeQueryBuilder withQuery(org.springframework.data.elasticsearch.core.query.Query query) {
        this.springDataQuery = query;
        return this;
    }

    public NativeQueryBuilder withKnnQuery(KnnQuery knnQuery) {
        this.knnQuery = knnQuery;
        return this;
    }

    public NativeQuery build() {
        Assert.isTrue((this.query == null || this.springDataQuery == null ? 1 : 0) != 0, (String)"Cannot have both a native query and a Spring Data query");
        return new NativeQuery(this);
    }
}

