/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.Field;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class CriteriaQueryProcessor {
    CriteriaQueryProcessor() {
    }

    @Nullable
    QueryBuilder createQuery(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria must not be null");
        ArrayList<QueryBuilder> shouldQueryBuilders = new ArrayList<QueryBuilder>();
        ArrayList<QueryBuilder> mustNotQueryBuilders = new ArrayList<QueryBuilder>();
        ArrayList<QueryBuilder> mustQueryBuilders = new ArrayList<QueryBuilder>();
        QueryBuilder firstQuery = null;
        boolean negateFirstQuery = false;
        for (Criteria chainedCriteria : criteria.getCriteriaChain()) {
            QueryBuilder queryFragment = this.queryForEntries(chainedCriteria);
            if (queryFragment == null) continue;
            if (firstQuery == null) {
                firstQuery = queryFragment;
                negateFirstQuery = chainedCriteria.isNegating();
                continue;
            }
            if (chainedCriteria.isOr()) {
                shouldQueryBuilders.add(queryFragment);
                continue;
            }
            if (chainedCriteria.isNegating()) {
                mustNotQueryBuilders.add(queryFragment);
                continue;
            }
            mustQueryBuilders.add(queryFragment);
        }
        for (Criteria subCriteria : criteria.getSubCriteria()) {
            QueryBuilder subQuery = this.createQuery(subCriteria);
            if (subQuery == null) continue;
            if (criteria.isOr()) {
                shouldQueryBuilders.add(subQuery);
                continue;
            }
            if (criteria.isNegating()) {
                mustNotQueryBuilders.add(subQuery);
                continue;
            }
            mustQueryBuilders.add(subQuery);
        }
        if (firstQuery != null) {
            if (!shouldQueryBuilders.isEmpty() && mustNotQueryBuilders.isEmpty() && mustQueryBuilders.isEmpty()) {
                shouldQueryBuilders.add(0, firstQuery);
            } else if (negateFirstQuery) {
                mustNotQueryBuilders.add(0, firstQuery);
            } else {
                mustQueryBuilders.add(0, firstQuery);
            }
        }
        BoolQueryBuilder query = null;
        if (!(shouldQueryBuilders.isEmpty() && mustNotQueryBuilders.isEmpty() && mustQueryBuilders.isEmpty())) {
            query = QueryBuilders.boolQuery();
            for (QueryBuilder qb : shouldQueryBuilders) {
                query.should(qb);
            }
            for (QueryBuilder qb : mustNotQueryBuilders) {
                query.mustNot(qb);
            }
            for (QueryBuilder qb : mustQueryBuilders) {
                query.must(qb);
            }
        }
        return query;
    }

    @Nullable
    private QueryBuilder queryForEntries(Criteria criteria) {
        BoolQueryBuilder query;
        Field field = criteria.getField();
        if (field == null || criteria.getQueryCriteriaEntries().isEmpty()) {
            return null;
        }
        String fieldName = field.getName();
        Assert.notNull((Object)fieldName, (String)("Unknown field " + fieldName));
        Iterator it = criteria.getQueryCriteriaEntries().iterator();
        if (criteria.getQueryCriteriaEntries().size() == 1) {
            query = this.queryFor((Criteria.CriteriaEntry)it.next(), field);
        } else {
            query = QueryBuilders.boolQuery();
            while (it.hasNext()) {
                Criteria.CriteriaEntry entry = (Criteria.CriteriaEntry)it.next();
                query.must(this.queryFor(entry, field));
            }
        }
        this.addBoost((QueryBuilder)query, criteria.getBoost());
        if (StringUtils.hasText((String)field.getPath())) {
            query = QueryBuilders.nestedQuery((String)field.getPath(), (QueryBuilder)query, (ScoreMode)ScoreMode.Avg);
        }
        return query;
    }

    @Nullable
    private QueryBuilder queryFor(Criteria.CriteriaEntry entry, Field field) {
        ExistsQueryBuilder query = null;
        String fieldName = field.getName();
        boolean isKeywordField = FieldType.Keyword == field.getFieldType();
        Criteria.OperationKey key = entry.getKey();
        switch (key) {
            case EXISTS: {
                query = QueryBuilders.existsQuery((String)fieldName);
                break;
            }
            case EMPTY: {
                query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)fieldName)).mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)"*"));
                break;
            }
            case NOT_EMPTY: {
                query = QueryBuilders.wildcardQuery((String)fieldName, (String)"*");
                break;
            }
        }
        if (query != null) {
            return query;
        }
        Object value = entry.getValue();
        String searchText = QueryParserUtil.escape((String)value.toString());
        switch (key) {
            case EQUALS: {
                query = QueryBuilders.queryStringQuery((String)searchText).field(fieldName).defaultOperator(Operator.AND);
                break;
            }
            case CONTAINS: {
                query = QueryBuilders.queryStringQuery((String)("*" + searchText + "*")).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case STARTS_WITH: {
                query = QueryBuilders.queryStringQuery((String)(searchText + "*")).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case ENDS_WITH: {
                query = QueryBuilders.queryStringQuery((String)("*" + searchText)).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case EXPRESSION: {
                query = QueryBuilders.queryStringQuery((String)value.toString()).field(fieldName);
                break;
            }
            case LESS_EQUAL: {
                query = QueryBuilders.rangeQuery((String)fieldName).lte(value);
                break;
            }
            case GREATER_EQUAL: {
                query = QueryBuilders.rangeQuery((String)fieldName).gte(value);
                break;
            }
            case BETWEEN: {
                Object[] ranges = (Object[])value;
                query = QueryBuilders.rangeQuery((String)fieldName).from(ranges[0]).to(ranges[1]);
                break;
            }
            case LESS: {
                query = QueryBuilders.rangeQuery((String)fieldName).lt(value);
                break;
            }
            case GREATER: {
                query = QueryBuilders.rangeQuery((String)fieldName).gt(value);
                break;
            }
            case FUZZY: {
                query = QueryBuilders.fuzzyQuery((String)fieldName, (String)searchText);
                break;
            }
            case MATCHES: {
                query = QueryBuilders.matchQuery((String)fieldName, (Object)value).operator(Operator.OR);
                break;
            }
            case MATCHES_ALL: {
                query = QueryBuilders.matchQuery((String)fieldName, (Object)value).operator(Operator.AND);
                break;
            }
            case IN: {
                if (!(value instanceof Iterable)) break;
                Iterable iterable = (Iterable)value;
                if (isKeywordField) {
                    query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, CriteriaQueryProcessor.toStringList(iterable)));
                    break;
                }
                query = QueryBuilders.queryStringQuery((String)CriteriaQueryProcessor.orQueryString(iterable)).field(fieldName);
                break;
            }
            case NOT_IN: {
                if (!(value instanceof Iterable)) break;
                Iterable iterable = (Iterable)value;
                if (isKeywordField) {
                    query = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, CriteriaQueryProcessor.toStringList(iterable)));
                    break;
                }
                query = QueryBuilders.queryStringQuery((String)("NOT(" + CriteriaQueryProcessor.orQueryString(iterable) + ")")).field(fieldName);
                break;
            }
            case REGEXP: {
                query = QueryBuilders.regexpQuery((String)fieldName, (String)value.toString());
            }
        }
        return query;
    }

    private static List<String> toStringList(Iterable<?> iterable) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object item : iterable) {
            list.add(item != null ? item.toString() : null);
        }
        return list;
    }

    private static String orQueryString(Iterable<?> iterable) {
        StringBuilder sb = new StringBuilder();
        for (Object item : iterable) {
            if (item == null) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('\"');
            sb.append(QueryParserUtil.escape((String)item.toString()));
            sb.append('\"');
        }
        return sb.toString();
    }

    private void addBoost(@Nullable QueryBuilder query, float boost) {
        if (query == null || Float.isNaN(boost)) {
            return;
        }
        query.boost(boost);
    }
}

