/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.LatLonGeoLocation;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.IdsQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchQuery;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryStringQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch._types.query_dsl.WildcardQuery;
import org.opensearch.client.opensearch._types.query_dsl.WrapperQuery;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.data.client.osc.NativeQuery;
import org.opensearch.data.client.osc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class Queries {
    private Queries() {
    }

    public static IdsQuery idsQuery(List<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        return IdsQuery.of(i -> i.values(ids));
    }

    public static Query idsQueryAsQuery(List<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        Function<Query.Builder, ObjectBuilder> builder = b -> b.ids(Queries.idsQuery(ids));
        return (Query)builder.apply(new Query.Builder()).build();
    }

    public static MatchQuery matchQuery(String fieldName, String query, @Nullable Operator operator, @Nullable Float boost) {
        Assert.notNull((Object)fieldName, (String)"fieldName must not be null");
        Assert.notNull((Object)query, (String)"query must not be null");
        return MatchQuery.of(mb -> (ObjectBuilder)mb.field(fieldName).query(FieldValue.of((String)query)).operator(operator).boost(boost));
    }

    public static Query matchQueryAsQuery(String fieldName, String query, @Nullable Operator operator, @Nullable Float boost) {
        Function<Query.Builder, ObjectBuilder> builder = b -> b.match(Queries.matchQuery(fieldName, query, operator, boost));
        return (Query)builder.apply(new Query.Builder()).build();
    }

    public static MatchAllQuery matchAllQuery() {
        return MatchAllQuery.of(b -> b);
    }

    public static Query matchAllQueryAsQuery() {
        Function<Query.Builder, ObjectBuilder> builder = b -> b.matchAll(Queries.matchAllQuery());
        return (Query)builder.apply(new Query.Builder()).build();
    }

    public static QueryStringQuery queryStringQuery(String fieldName, String query, @Nullable Float boost) {
        return Queries.queryStringQuery(fieldName, query, null, null, boost);
    }

    public static QueryStringQuery queryStringQuery(String fieldName, String query, Operator defaultOperator, @Nullable Float boost) {
        return Queries.queryStringQuery(fieldName, query, null, defaultOperator, boost);
    }

    public static QueryStringQuery queryStringQuery(String fieldName, String query, @Nullable Boolean analyzeWildcard, @Nullable Float boost) {
        return Queries.queryStringQuery(fieldName, query, analyzeWildcard, null, boost);
    }

    public static QueryStringQuery queryStringQuery(String fieldName, String query, @Nullable Boolean analyzeWildcard, @Nullable Operator defaultOperator, @Nullable Float boost) {
        Assert.notNull((Object)fieldName, (String)"fieldName must not be null");
        Assert.notNull((Object)query, (String)"query must not be null");
        return QueryStringQuery.of(qs -> (ObjectBuilder)qs.fields(fieldName, new String[0]).query(query).analyzeWildcard(analyzeWildcard).defaultOperator(defaultOperator).boost(boost));
    }

    public static TermQuery termQuery(String fieldName, String value) {
        Assert.notNull((Object)fieldName, (String)"fieldName must not be null");
        Assert.notNull((Object)value, (String)"value must not be null");
        return TermQuery.of(t -> t.field(fieldName).value(FieldValue.of((String)value)));
    }

    public static Query termQueryAsQuery(String fieldName, String value) {
        Function<Query.Builder, ObjectBuilder> builder = q -> q.term(Queries.termQuery(fieldName, value));
        return (Query)builder.apply(new Query.Builder()).build();
    }

    public static WildcardQuery wildcardQuery(String field, String value) {
        Assert.notNull((Object)field, (String)"field must not be null");
        Assert.notNull((Object)value, (String)"value must not be null");
        return WildcardQuery.of(w -> w.field(field).wildcard(value));
    }

    public static Query wildcardQueryAsQuery(String field, String value) {
        Function<Query.Builder, ObjectBuilder> builder = q -> q.wildcard(Queries.wildcardQuery(field, value));
        return (Query)builder.apply(new Query.Builder()).build();
    }

    public static Query wrapperQueryAsQuery(String query) {
        Function<Query.Builder, ObjectBuilder> builder = q -> q.wrapper(Queries.wrapperQuery(query));
        return (Query)builder.apply(new Query.Builder()).build();
    }

    public static WrapperQuery wrapperQuery(String query) {
        Assert.notNull((Object)query, (String)"query must not be null");
        String encodedValue = Base64.getEncoder().encodeToString(query.getBytes(StandardCharsets.UTF_8));
        return WrapperQuery.of(wq -> wq.query(encodedValue));
    }

    public static LatLonGeoLocation latLon(GeoPoint geoPoint) {
        Assert.notNull((Object)geoPoint, (String)"geoPoint must not be null");
        return Queries.latLon(geoPoint.getLat(), geoPoint.getLon());
    }

    public static LatLonGeoLocation latLon(double lat, double lon) {
        return LatLonGeoLocation.of(_0 -> _0.lat(lat).lon(lon));
    }

    public static org.springframework.data.elasticsearch.core.query.Query getTermsAggsQuery(String aggsName, String aggsField) {
        return ((NativeQueryBuilder)NativeQuery.builder().withQuery(Queries.matchAllQueryAsQuery()).withAggregation(aggsName, Aggregation.of(a -> a.terms(ta -> ta.field(aggsField)))).withMaxResults(0)).build();
    }

    public static org.springframework.data.elasticsearch.core.query.Query queryWithIds(String ... ids) {
        return ((NativeQueryBuilder)NativeQuery.builder().withIds(ids)).build();
    }

    public static BaseQueryBuilder<?, ?> getBuilderWithMatchAllQuery() {
        return NativeQuery.builder().withQuery(Queries.matchAllQueryAsQuery());
    }

    public static BaseQueryBuilder<?, ?> getBuilderWithTermQuery(String field, String value) {
        return NativeQuery.builder().withQuery(Queries.termQueryAsQuery(field, value));
    }
}

