/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spring.boot.autoconfigure;

import org.opensearch.client.RestClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.data.client.osc.ReactiveOpenSearchClient;
import org.opensearch.spring.boot.autoconfigure.OpenSearchClientAutoConfiguration;
import org.opensearch.spring.boot.autoconfigure.OpenSearchClientConfigurations;
import org.opensearch.spring.boot.autoconfigure.OpenSearchProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import reactor.core.publisher.Mono;

@AutoConfiguration(after={OpenSearchClientAutoConfiguration.class})
@ConditionalOnBean(value={RestClient.class})
@ConditionalOnClass(value={OpenSearchTransport.class, Mono.class})
@EnableConfigurationProperties(value={OpenSearchProperties.class})
@Import(value={OpenSearchClientConfigurations.JsonpMapperConfiguration.class, OpenSearchClientConfigurations.OpenSearchTransportConfiguration.class})
public class ReactiveOpenSearchClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={OpenSearchTransport.class})
    ReactiveOpenSearchClient reactiveOpensearchClient(OpenSearchTransport transport) {
        return new ReactiveOpenSearchClient(transport);
    }
}

