/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spring.boot.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.bind.Jsonb;
import jakarta.json.spi.JsonProvider;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.json.jsonb.JsonbJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.rest_client.RestClientOptions;
import org.opensearch.client.transport.rest_client.RestClientTransport;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

class OpenSearchClientConfigurations {
    OpenSearchClientConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={OpenSearchTransport.class})
    static class OpenSearchClientConfiguration {
        OpenSearchClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        OpenSearchClient opensearchClient(OpenSearchTransport transport) {
            return new OpenSearchClient(transport);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={OpenSearchTransport.class})
    static class OpenSearchTransportConfiguration {
        OpenSearchTransportConfiguration() {
        }

        @Bean
        RestClientTransport restClientTransport(RestClient restClient, JsonpMapper jsonMapper, ObjectProvider<RestClientOptions> restClientOptions) {
            return new RestClientTransport(restClient, jsonMapper, (TransportOptions)restClientOptions.getIfAvailable());
        }
    }

    @ConditionalOnMissingBean(value={JsonpMapper.class})
    @ConditionalOnBean(value={Jsonb.class})
    @Configuration(proxyBeanMethods=false)
    static class JsonbJsonpMapperConfiguration {
        JsonbJsonpMapperConfiguration() {
        }

        @Bean
        JsonbJsonpMapper jsonbJsonpMapper(Jsonb jsonb) {
            return new JsonbJsonpMapper(JsonProvider.provider(), jsonb);
        }
    }

    @ConditionalOnMissingBean(value={JsonpMapper.class})
    @ConditionalOnClass(value={ObjectMapper.class})
    @Configuration(proxyBeanMethods=false)
    static class JacksonJsonpMapperConfiguration {
        JacksonJsonpMapperConfiguration() {
        }

        @Bean
        JacksonJsonpMapper jacksonJsonpMapper() {
            return new JacksonJsonpMapper();
        }
    }

    @Import(value={JacksonJsonpMapperConfiguration.class, JsonbJsonpMapperConfiguration.class})
    static class JsonpMapperConfiguration {
        JsonpMapperConfiguration() {
        }
    }
}

