/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.update_aliases;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.update_aliases.Action;
import org.opensearch.client.opensearch.indices.update_aliases.ActionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RemoveAction
implements ActionVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, RemoveAction> {
    @Nullable
    private final String alias;
    @Nonnull
    private final List<String> aliases;
    @Nullable
    private final String index;
    @Nonnull
    private final List<String> indices;
    @Nullable
    private final Boolean mustExist;
    public static final JsonpDeserializer<RemoveAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoveAction::setupRemoveActionDeserializer);

    private RemoveAction(Builder builder) {
        this.alias = builder.alias;
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.index = builder.index;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.mustExist = builder.mustExist;
    }

    public static RemoveAction of(Function<Builder, ObjectBuilder<RemoveAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Action.Kind _actionKind() {
        return Action.Kind.Remove;
    }

    @Nullable
    public final String alias() {
        return this.alias;
    }

    @Nonnull
    public final List<String> aliases() {
        return this.aliases;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final Boolean mustExist() {
        return this.mustExist;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alias != null) {
            generator.writeKey("alias");
            generator.write(this.alias);
        }
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (String item0 : this.aliases) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.mustExist != null) {
            generator.writeKey("must_exist");
            generator.write(this.mustExist.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRemoveActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alias, JsonpDeserializer.stringDeserializer(), "alias");
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "aliases");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::mustExist, JsonpDeserializer.booleanDeserializer(), "must_exist");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.alias);
        result = 31 * result + Objects.hashCode(this.aliases);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.mustExist);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveAction other = (RemoveAction)o;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.aliases, other.aliases) && Objects.equals(this.index, other.index) && Objects.equals(this.indices, other.indices) && Objects.equals(this.mustExist, other.mustExist);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RemoveAction> {
        @Nullable
        private String alias;
        @Nullable
        private List<String> aliases;
        @Nullable
        private String index;
        @Nullable
        private List<String> indices;
        @Nullable
        private Boolean mustExist;

        public Builder() {
        }

        private Builder(RemoveAction o) {
            this.alias = o.alias;
            this.aliases = Builder._listCopy(o.aliases);
            this.index = o.index;
            this.indices = Builder._listCopy(o.indices);
            this.mustExist = o.mustExist;
        }

        private Builder(Builder o) {
            this.alias = o.alias;
            this.aliases = Builder._listCopy(o.aliases);
            this.index = o.index;
            this.indices = Builder._listCopy(o.indices);
            this.mustExist = o.mustExist;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder alias(@Nullable String value) {
            this.alias = value;
            return this;
        }

        @Nonnull
        public final Builder aliases(List<String> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        @Nonnull
        public final Builder aliases(String value, String ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Nonnull
        public final Builder mustExist(@Nullable Boolean value) {
            this.mustExist = value;
            return this;
        }

        @Override
        @Nonnull
        public RemoveAction build() {
            this._checkSingleUse();
            return new RemoveAction(this);
        }
    }
}

