/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.CalendarInterval;
import org.opensearch.client.opensearch._types.aggregations.FormatMetricAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.RateMode;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RateAggregation
extends FormatMetricAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, RateAggregation> {
    @Nullable
    private final RateMode mode;
    @Nullable
    private final CalendarInterval unit;
    public static final JsonpDeserializer<RateAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RateAggregation::setupRateAggregationDeserializer);

    private RateAggregation(Builder builder) {
        super(builder);
        this.mode = builder.mode;
        this.unit = builder.unit;
    }

    public static RateAggregation of(Function<Builder, ObjectBuilder<RateAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Rate;
    }

    @Nullable
    public final RateMode mode() {
        return this.mode;
    }

    @Nullable
    public final CalendarInterval unit() {
        return this.unit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRateAggregationDeserializer(ObjectDeserializer<Builder> op) {
        RateAggregation.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::mode, RateMode._DESERIALIZER, "mode");
        op.add(Builder::unit, CalendarInterval._DESERIALIZER, "unit");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.mode);
        result = 31 * result + Objects.hashCode(this.unit);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateAggregation other = (RateAggregation)o;
        return Objects.equals(this.mode, other.mode) && Objects.equals(this.unit, other.unit);
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RateAggregation> {
        @Nullable
        private RateMode mode;
        @Nullable
        private CalendarInterval unit;

        public Builder() {
        }

        private Builder(RateAggregation o) {
            super(o);
            this.mode = o.mode;
            this.unit = o.unit;
        }

        private Builder(Builder o) {
            super(o);
            this.mode = o.mode;
            this.unit = o.unit;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder mode(@Nullable RateMode value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder unit(@Nullable CalendarInterval value) {
            this.unit = value;
            return this;
        }

        @Override
        @Nonnull
        public RateAggregation build() {
            this._checkSingleUse();
            return new RateAggregation(this);
        }
    }
}

