/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class TermQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final FieldValue value;
    @Nullable
    private final Boolean caseInsensitive;
    public static final JsonpDeserializer<TermQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermQuery::setupTermQueryDeserializer);

    private TermQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
        this.caseInsensitive = builder.caseInsensitive;
    }

    public static TermQuery of(Function<Builder, ObjectBuilder<TermQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Term;
    }

    public final String field() {
        return this.field;
    }

    public final FieldValue value() {
        return this.value;
    }

    @Nullable
    public final Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return new Builder().field(this.field).value(this.value).caseInsensitive(this.caseInsensitive);
    }

    protected static void setupTermQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::value, FieldValue._DESERIALIZER, "value");
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermQuery> {
        private String field;
        private FieldValue value;
        @Nullable
        private Boolean caseInsensitive;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder value(FieldValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.value(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermQuery build() {
            this._checkSingleUse();
            return new TermQuery(this);
        }
    }
}

