/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.TextQueryType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class QueryStringQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Boolean allowLeadingWildcard;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final String defaultField;
    @Nullable
    private final Operator defaultOperator;
    @Nullable
    private final Boolean enablePositionIncrements;
    @Nullable
    private final Boolean escape;
    private final List<String> fields;
    @Nullable
    private final String fuzziness;
    @Nullable
    private final Integer fuzzyMaxExpansions;
    @Nullable
    private final Integer fuzzyPrefixLength;
    @Nullable
    private final String fuzzyRewrite;
    @Nullable
    private final Boolean fuzzyTranspositions;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Integer maxDeterminizedStates;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final Double phraseSlop;
    private final String query;
    @Nullable
    private final String quoteAnalyzer;
    @Nullable
    private final String quoteFieldSuffix;
    @Nullable
    private final String rewrite;
    @Nullable
    private final Double tieBreaker;
    @Nullable
    private final String timeZone;
    @Nullable
    private final TextQueryType type;
    public static final JsonpDeserializer<QueryStringQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryStringQuery::setupQueryStringQueryDeserializer);

    private QueryStringQuery(Builder builder) {
        super(builder);
        this.allowLeadingWildcard = builder.allowLeadingWildcard;
        this.analyzer = builder.analyzer;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.defaultField = builder.defaultField;
        this.defaultOperator = builder.defaultOperator;
        this.enablePositionIncrements = builder.enablePositionIncrements;
        this.escape = builder.escape;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.fuzziness = builder.fuzziness;
        this.fuzzyMaxExpansions = builder.fuzzyMaxExpansions;
        this.fuzzyPrefixLength = builder.fuzzyPrefixLength;
        this.fuzzyRewrite = builder.fuzzyRewrite;
        this.fuzzyTranspositions = builder.fuzzyTranspositions;
        this.lenient = builder.lenient;
        this.maxDeterminizedStates = builder.maxDeterminizedStates;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.phraseSlop = builder.phraseSlop;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.quoteAnalyzer = builder.quoteAnalyzer;
        this.quoteFieldSuffix = builder.quoteFieldSuffix;
        this.rewrite = builder.rewrite;
        this.tieBreaker = builder.tieBreaker;
        this.timeZone = builder.timeZone;
        this.type = builder.type;
    }

    public static QueryStringQuery of(Function<Builder, ObjectBuilder<QueryStringQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.QueryString;
    }

    @Nullable
    public final Boolean allowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public final Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nullable
    public final String defaultField() {
        return this.defaultField;
    }

    @Nullable
    public final Operator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public final Boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    @Nullable
    public final Boolean escape() {
        return this.escape;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public final Integer fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    @Nullable
    public final Integer fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    @Nullable
    public final String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    @Nullable
    public final Boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public final Integer maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public final Double phraseSlop() {
        return this.phraseSlop;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final String quoteAnalyzer() {
        return this.quoteAnalyzer;
    }

    @Nullable
    public final String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    @Nullable
    public final String rewrite() {
        return this.rewrite;
    }

    @Nullable
    public final Double tieBreaker() {
        return this.tieBreaker;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public final TextQueryType type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.allowLeadingWildcard != null) {
            generator.writeKey("allow_leading_wildcard");
            generator.write(this.allowLeadingWildcard.booleanValue());
        }
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.analyzeWildcard != null) {
            generator.writeKey("analyze_wildcard");
            generator.write(this.analyzeWildcard.booleanValue());
        }
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.defaultField != null) {
            generator.writeKey("default_field");
            generator.write(this.defaultField);
        }
        if (this.defaultOperator != null) {
            generator.writeKey("default_operator");
            this.defaultOperator.serialize(generator, mapper);
        }
        if (this.enablePositionIncrements != null) {
            generator.writeKey("enable_position_increments");
            generator.write(this.enablePositionIncrements.booleanValue());
        }
        if (this.escape != null) {
            generator.writeKey("escape");
            generator.write(this.escape.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.fuzzyMaxExpansions != null) {
            generator.writeKey("fuzzy_max_expansions");
            generator.write(this.fuzzyMaxExpansions.intValue());
        }
        if (this.fuzzyPrefixLength != null) {
            generator.writeKey("fuzzy_prefix_length");
            generator.write(this.fuzzyPrefixLength.intValue());
        }
        if (this.fuzzyRewrite != null) {
            generator.writeKey("fuzzy_rewrite");
            generator.write(this.fuzzyRewrite);
        }
        if (this.fuzzyTranspositions != null) {
            generator.writeKey("fuzzy_transpositions");
            generator.write(this.fuzzyTranspositions.booleanValue());
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (this.maxDeterminizedStates != null) {
            generator.writeKey("max_determinized_states");
            generator.write(this.maxDeterminizedStates.intValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.phraseSlop != null) {
            generator.writeKey("phrase_slop");
            generator.write(this.phraseSlop.doubleValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.quoteAnalyzer != null) {
            generator.writeKey("quote_analyzer");
            generator.write(this.quoteAnalyzer);
        }
        if (this.quoteFieldSuffix != null) {
            generator.writeKey("quote_field_suffix");
            generator.write(this.quoteFieldSuffix);
        }
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        if (this.tieBreaker != null) {
            generator.writeKey("tie_breaker");
            generator.write(this.tieBreaker.doubleValue());
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).allowLeadingWildcard(this.allowLeadingWildcard).analyzer(this.analyzer).analyzeWildcard(this.analyzeWildcard).autoGenerateSynonymsPhraseQuery(this.autoGenerateSynonymsPhraseQuery).defaultField(this.defaultField).defaultOperator(this.defaultOperator).enablePositionIncrements(this.enablePositionIncrements).escape(this.escape).fields(this.fields).fuzziness(this.fuzziness).fuzzyMaxExpansions(this.fuzzyMaxExpansions).fuzzyPrefixLength(this.fuzzyPrefixLength).fuzzyRewrite(this.fuzzyRewrite).fuzzyTranspositions(this.fuzzyTranspositions).lenient(this.lenient).maxDeterminizedStates(this.maxDeterminizedStates).minimumShouldMatch(this.minimumShouldMatch).phraseSlop(this.phraseSlop).query(this.query).quoteAnalyzer(this.quoteAnalyzer).quoteFieldSuffix(this.quoteFieldSuffix).rewrite(this.rewrite).tieBreaker(this.tieBreaker).timeZone(this.timeZone).type(this.type);
    }

    protected static void setupQueryStringQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::allowLeadingWildcard, JsonpDeserializer.booleanDeserializer(), "allow_leading_wildcard");
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::analyzeWildcard, JsonpDeserializer.booleanDeserializer(), "analyze_wildcard");
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query");
        op.add(Builder::defaultField, JsonpDeserializer.stringDeserializer(), "default_field");
        op.add(Builder::defaultOperator, Operator._DESERIALIZER, "default_operator");
        op.add(Builder::enablePositionIncrements, JsonpDeserializer.booleanDeserializer(), "enable_position_increments");
        op.add(Builder::escape, JsonpDeserializer.booleanDeserializer(), "escape");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::fuzzyMaxExpansions, JsonpDeserializer.integerDeserializer(), "fuzzy_max_expansions");
        op.add(Builder::fuzzyPrefixLength, JsonpDeserializer.integerDeserializer(), "fuzzy_prefix_length");
        op.add(Builder::fuzzyRewrite, JsonpDeserializer.stringDeserializer(), "fuzzy_rewrite");
        op.add(Builder::fuzzyTranspositions, JsonpDeserializer.booleanDeserializer(), "fuzzy_transpositions");
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient");
        op.add(Builder::maxDeterminizedStates, JsonpDeserializer.integerDeserializer(), "max_determinized_states");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::phraseSlop, JsonpDeserializer.doubleDeserializer(), "phrase_slop");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::quoteAnalyzer, JsonpDeserializer.stringDeserializer(), "quote_analyzer");
        op.add(Builder::quoteFieldSuffix, JsonpDeserializer.stringDeserializer(), "quote_field_suffix");
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite");
        op.add(Builder::tieBreaker, JsonpDeserializer.doubleDeserializer(), "tie_breaker");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
        op.add(Builder::type, TextQueryType._DESERIALIZER, "type");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<QueryStringQuery> {
        @Nullable
        private Boolean allowLeadingWildcard;
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private String defaultField;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private Boolean enablePositionIncrements;
        @Nullable
        private Boolean escape;
        @Nullable
        private List<String> fields;
        @Nullable
        private String fuzziness;
        @Nullable
        private Integer fuzzyMaxExpansions;
        @Nullable
        private Integer fuzzyPrefixLength;
        @Nullable
        private String fuzzyRewrite;
        @Nullable
        private Boolean fuzzyTranspositions;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Integer maxDeterminizedStates;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private Double phraseSlop;
        private String query;
        @Nullable
        private String quoteAnalyzer;
        @Nullable
        private String quoteFieldSuffix;
        @Nullable
        private String rewrite;
        @Nullable
        private Double tieBreaker;
        @Nullable
        private String timeZone;
        @Nullable
        private TextQueryType type;

        public final Builder allowLeadingWildcard(@Nullable Boolean value) {
            this.allowLeadingWildcard = value;
            return this;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public final Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        public final Builder defaultField(@Nullable String value) {
            this.defaultField = value;
            return this;
        }

        public final Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        public final Builder enablePositionIncrements(@Nullable Boolean value) {
            this.enablePositionIncrements = value;
            return this;
        }

        public final Builder escape(@Nullable Boolean value) {
            this.escape = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public final Builder fuzzyMaxExpansions(@Nullable Integer value) {
            this.fuzzyMaxExpansions = value;
            return this;
        }

        public final Builder fuzzyPrefixLength(@Nullable Integer value) {
            this.fuzzyPrefixLength = value;
            return this;
        }

        public final Builder fuzzyRewrite(@Nullable String value) {
            this.fuzzyRewrite = value;
            return this;
        }

        public final Builder fuzzyTranspositions(@Nullable Boolean value) {
            this.fuzzyTranspositions = value;
            return this;
        }

        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public final Builder maxDeterminizedStates(@Nullable Integer value) {
            this.maxDeterminizedStates = value;
            return this;
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder phraseSlop(@Nullable Double value) {
            this.phraseSlop = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder quoteAnalyzer(@Nullable String value) {
            this.quoteAnalyzer = value;
            return this;
        }

        public final Builder quoteFieldSuffix(@Nullable String value) {
            this.quoteFieldSuffix = value;
            return this;
        }

        public final Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        public final Builder tieBreaker(@Nullable Double value) {
            this.tieBreaker = value;
            return this;
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        public final Builder type(@Nullable TextQueryType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryStringQuery build() {
            this._checkSingleUse();
            return new QueryStringQuery(this);
        }
    }
}

