/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.RegisterModelResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RegisterModelRequest
extends RequestBase
implements PlainJsonSerializable {
    @Nullable
    private final String description;
    private final String modelFormat;
    @Nullable
    private final String modelGroupId;
    private final String name;
    private final String version;
    public static final JsonpDeserializer<RegisterModelRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RegisterModelRequest::setupRegisterModelRequestDeserializer);
    public static final Endpoint<RegisterModelRequest, RegisterModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RegisterModelRequest, RegisterModelResponse>(request -> "POST", request -> "/_plugins/_ml/models/_register", SimpleEndpoint.emptyMap(), SimpleEndpoint.emptyMap(), true, RegisterModelResponse._DESERIALIZER);

    private RegisterModelRequest(Builder builder) {
        this.description = builder.description;
        this.modelFormat = ApiTypeHelper.requireNonNull(builder.modelFormat, this, "modelFormat");
        this.modelGroupId = builder.modelGroupId;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static RegisterModelRequest of(Function<Builder, ObjectBuilder<RegisterModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String modelFormat() {
        return this.modelFormat;
    }

    @Nullable
    public final String modelGroupId() {
        return this.modelGroupId;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("model_format");
        generator.write(this.modelFormat);
        if (this.modelGroupId != null) {
            generator.writeKey("model_group_id");
            generator.write(this.modelGroupId);
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupRegisterModelRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::modelFormat, JsonpDeserializer.stringDeserializer(), "model_format");
        op.add(Builder::modelGroupId, JsonpDeserializer.stringDeserializer(), "model_group_id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RegisterModelRequest> {
        @Nullable
        private String description;
        private String modelFormat;
        @Nullable
        private String modelGroupId;
        private String name;
        private String version;

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder modelFormat(String value) {
            this.modelFormat = value;
            return this;
        }

        public final Builder modelGroupId(@Nullable String value) {
            this.modelGroupId = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        public RegisterModelRequest build() {
            this._checkSingleUse();
            return new RegisterModelRequest(this);
        }
    }
}

