/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.layout.IdentityTemplateLibrary;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

final class MacroCycleLayout {
    private static IdentityTemplateLibrary TEMPLATES = IdentityTemplateLibrary.loadFromResource("macro.smi");
    public static String MACROCYCLE_ATOM_HINT = "layout.macrocycle.atom.hint";
    private static final int CW = -1;
    private static final int CCW = 1;
    private final IAtomContainer mol;
    private final int[][] adjList;
    private final Map<IAtom, Integer> idxs = new HashMap<IAtom, Integer>();

    public MacroCycleLayout(IAtomContainer mol) {
        this.mol = mol;
        this.adjList = GraphUtil.toAdjList((IAtomContainer)mol);
        for (IAtom atom : mol.atoms()) {
            this.idxs.put(atom, this.idxs.size());
        }
    }

    boolean layout(IRing macrocycle, IRingSet ringset) {
        IAtomContainer anon = MacroCycleLayout.roundUpIfNeeded(AtomContainerManipulator.anonymise((IAtomContainer)macrocycle));
        Collection<Point2d[]> coords = TEMPLATES.getCoordinates(anon);
        if (coords.isEmpty()) {
            return false;
        }
        Point2d[] best = new Point2d[anon.getAtomCount()];
        int bestOffset = this.selectCoords(coords, best, macrocycle, ringset);
        for (int i = 0; i < macrocycle.getAtomCount(); ++i) {
            macrocycle.getAtom(i).setPoint2d(best[(bestOffset + i) % macrocycle.getAtomCount()]);
            macrocycle.getAtom(i).setFlag(1, true);
            macrocycle.getAtom(i).setProperty((Object)MACROCYCLE_ATOM_HINT, (Object)true);
        }
        macrocycle.setFlag(1, true);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private MacroScore bestScore(IRing macrocycle, IRingSet ringset, int wind, int[] winding) {
        int numAtoms = macrocycle.getAtomCount();
        ArrayList<Integer> heteroIdxs = new ArrayList<Integer>();
        ArrayList<List<Integer>> ringAttachs = new ArrayList<List<Integer>>();
        for (int i = 0; i < numAtoms; ++i) {
            if (macrocycle.getAtom(i).getAtomicNumber() == 6) continue;
            heteroIdxs.add(i);
        }
        for (IAtomContainer other : ringset.atomContainers()) {
            IAtomContainer shared;
            if (other == macrocycle || (shared = AtomContainerManipulator.getIntersection((IAtomContainer)macrocycle, (IAtomContainer)other)).getAtomCount() < 2 || shared.getAtomCount() > 4) continue;
            ringAttachs.add(this.getAttachedInOrder(macrocycle, shared));
        }
        int convex = wind;
        int concave = -wind;
        MacroScore best = null;
        for (int i = 0; i < winding.length; ++i) {
            void var14_18;
            int nRingClick = 0;
            for (List list : ringAttachs) {
                switch (list.size()) {
                    case 2: {
                        int r1 = ((Integer)list.get(0) + i) % numAtoms;
                        int r2 = ((Integer)list.get(1) + i) % numAtoms;
                        if (winding[r1] != winding[r2]) break;
                        if (winding[r1] == convex) {
                            nRingClick += 5;
                            break;
                        }
                        ++nRingClick;
                        break;
                    }
                    case 3: {
                        int r1 = ((Integer)list.get(0) + i) % numAtoms;
                        int r2 = ((Integer)list.get(1) + i) % numAtoms;
                        int r3 = ((Integer)list.get(2) + i) % numAtoms;
                        if (winding[r1] == convex && winding[r2] == concave && winding[r3] == convex) {
                            nRingClick += 5;
                            break;
                        }
                        if (winding[r1] != concave || winding[r2] != convex || winding[r3] != concave) break;
                        ++nRingClick;
                        break;
                    }
                    case 4: {
                        int r1 = ((Integer)list.get(0) + i) % numAtoms;
                        int r2 = ((Integer)list.get(1) + i) % numAtoms;
                        int r3 = ((Integer)list.get(2) + i) % numAtoms;
                        int r4 = ((Integer)list.get(3) + i) % numAtoms;
                        if (winding[r1] == convex && winding[r2] == concave && winding[r3] == concave && winding[r4] == convex) {
                            ++nRingClick;
                            break;
                        }
                        if (winding[r1] != concave || winding[r2] != convex || winding[r3] != convex || winding[r4] != concave) break;
                        ++nRingClick;
                    }
                }
            }
            int nConcaveHetero = 0;
            Iterator iterator = heteroIdxs.iterator();
            while (iterator.hasNext()) {
                int heteroIdx = (Integer)iterator.next();
                int k = (heteroIdx + i) % numAtoms;
                if (winding[k] != concave) continue;
                ++nConcaveHetero;
            }
            boolean bl = false;
            int nIncorrectStereo = 0;
            for (IStereoElement se : macrocycle.stereoElements()) {
                if (se.getConfigClass() != 8448) continue;
                IBond bond = (IBond)se.getFocus();
                IAtom beg = bond.getBegin();
                IAtom end = bond.getEnd();
                int cfg = winding[(macrocycle.indexOf(beg) + i) % numAtoms] == winding[(macrocycle.indexOf(end) + i) % numAtoms] ? 2 : 1;
                if (cfg == se.getConfigOrder()) {
                    ++var14_18;
                    continue;
                }
                ++nIncorrectStereo;
            }
            MacroScore score = new MacroScore(i, nConcaveHetero, (int)var14_18, nRingClick);
            if (score.compareTo(best) >= 0) continue;
            best = score;
        }
        return best;
    }

    private List<Integer> getAttachedInOrder(IRing macrocycle, IAtomContainer shared) {
        ArrayList<Integer> ringAttach = new ArrayList<Integer>();
        HashSet<IAtom> visit = new HashSet<IAtom>();
        IAtom atom = shared.getAtom(0);
        block0: while (atom != null) {
            visit.add(atom);
            ringAttach.add(macrocycle.indexOf(atom));
            List connected = shared.getConnectedAtomsList(atom);
            atom = null;
            for (IAtom neighbor : connected) {
                if (visit.contains(neighbor)) continue;
                atom = neighbor;
                continue block0;
            }
        }
        return ringAttach;
    }

    private int selectCoords(Collection<Point2d[]> ps, Point2d[] coords, IRing macrocycle, IRingSet ringset) {
        assert (ps.size() != 0);
        int[] winding = new int[coords.length];
        MacroScore best = null;
        for (Point2d[] p : ps) {
            int wind = MacroCycleLayout.winding(p, winding);
            MacroScore score = this.bestScore(macrocycle, ringset, wind, winding);
            if (score.compareTo(best) >= 0) continue;
            best = score;
            System.arraycopy(p, 0, coords, 0, p.length);
        }
        return best != null ? best.offset : 0;
    }

    private static int winding(Point2d[] coords, int[] winding) {
        int cw = 0;
        int ccw = 0;
        Point2d prev = coords[coords.length - 1];
        for (int i = 0; i < coords.length; ++i) {
            Point2d curr = coords[i];
            Point2d next = coords[(i + 1) % coords.length];
            winding[i] = MacroCycleLayout.winding(prev, curr, next);
            if (winding[i] < 0) {
                ++cw;
            } else if (winding[i] > 0) {
                ++ccw;
            } else {
                return 0;
            }
            prev = curr;
        }
        if (cw == ccw) {
            return 0;
        }
        return cw > ccw ? -1 : 1;
    }

    private static int winding(Point2d a, Point2d b, Point2d c) {
        return (int)Math.signum((b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x));
    }

    private static IAtomContainer roundUpIfNeeded(IAtomContainer anon) {
        IChemObjectBuilder bldr = anon.getBuilder();
        if ((anon.getAtomCount() & 1) != 0) {
            IBond bond = anon.removeBond(anon.getBondCount() - 1);
            IAtom dummy = (IAtom)bldr.newInstance(IAtom.class, new Object[]{"C"});
            anon.addAtom(dummy);
            anon.addBond((IBond)bldr.newInstance(IBond.class, new Object[]{bond.getBegin(), dummy, IBond.Order.SINGLE}));
            anon.addBond((IBond)bldr.newInstance(IBond.class, new Object[]{dummy, bond.getEnd(), IBond.Order.SINGLE}));
        }
        return anon;
    }

    private static final class MacroScore
    implements Comparable<MacroScore> {
        final int offset;
        final int nConcaveHetero;
        final int nRingClick;
        final int nCorrectStereo;

        public MacroScore(int offset, int nConcaveHetero, int nCorrectStereo, int nRingClick) {
            this.offset = offset;
            this.nConcaveHetero = nConcaveHetero;
            this.nRingClick = nRingClick;
            this.nCorrectStereo = nCorrectStereo;
        }

        @Override
        public int compareTo(MacroScore o) {
            if (o == null) {
                return -1;
            }
            int cmp = 0;
            cmp = -Integer.compare(this.nRingClick, o.nRingClick);
            if (cmp != 0) {
                return cmp;
            }
            cmp = -Integer.compare(this.nCorrectStereo, o.nCorrectStereo);
            if (cmp != 0) {
                return cmp;
            }
            cmp = -Integer.compare(this.nConcaveHetero, o.nConcaveHetero);
            return cmp;
        }
    }
}

