/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.Mol2Format;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Mol2Reader
extends DefaultChemObjectReader {
    boolean firstLineisMolecule = false;
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Mol2Reader.class);
    private static final Map<String, String> ATOM_TYPE_ALIASES = ImmutableMap.builder().put((Object)"S.o2", (Object)"S.O2").put((Object)"S.o", (Object)"S.O").put((Object)"CL", (Object)"Cl").put((Object)"CU", (Object)"Cu").put((Object)"FE", (Object)"Fe").put((Object)"BR", (Object)"Br").put((Object)"NA", (Object)"Na").put((Object)"SI", (Object)"Si").put((Object)"CA", (Object)"Ca").put((Object)"ZN", (Object)"Zn").put((Object)"LI", (Object)"Li").put((Object)"MG", (Object)"Mg").build();

    public Mol2Reader(Reader in) {
        this.input = new BufferedReader(in);
    }

    public Mol2Reader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public Mol2Reader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return Mol2Format.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        return superClass != null && this.accepts(superClass);
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule((IAtomContainer)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IAtomContainer m;
        IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
        if (setOfMolecules == null) {
            setOfMolecules = (IAtomContainerSet)chemModel.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        }
        if ((m = this.readMolecule((IAtomContainer)chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]))) != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        return chemModel;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence chemSequence = (IChemSequence)chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = (IChemModel)chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet setOfMolecules = (IAtomContainerSet)chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainer m = this.readMolecule((IAtomContainer)chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
        if (m != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        chemSequence.addChemModel(chemModel);
        setOfMolecules = (IAtomContainerSet)chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        chemModel = (IChemModel)chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        try {
            this.firstLineisMolecule = true;
            while (m != null) {
                m = this.readMolecule((IAtomContainer)chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
                if (m == null) continue;
                setOfMolecules.addAtomContainer(m);
                chemModel.setMoleculeSet(setOfMolecules);
                chemSequence.addChemModel(chemModel);
                setOfMolecules = (IAtomContainerSet)chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                chemModel = (IChemModel)chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (IllegalArgumentException exception) {
            String error = "Error while parsing MOL2";
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exc) {
            String error = "Error while closing file: " + exc.getMessage();
            logger.error((Object)error);
            throw new CDKException(error, (Throwable)exc);
        }
        chemFile.addChemSequence(chemSequence);
        this.firstLineisMolecule = false;
        return chemFile;
    }

    public boolean accepts(IChemObject object) {
        if (object instanceof IChemFile) {
            return true;
        }
        if (object instanceof IChemModel) {
            return true;
        }
        return object instanceof IAtomContainer;
    }

    private IAtomContainer readMolecule(IAtomContainer molecule) throws CDKException {
        AtomTypeFactory atFactory = null;
        try {
            atFactory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/mol2_atomtypes.xml", (IChemObjectBuilder)molecule.getBuilder());
        }
        catch (Exception exception) {
            String error = "Could not instantiate an AtomTypeFactory";
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        try {
            String line;
            int atomCount = 0;
            int bondCount = 0;
            do {
                if ((line = this.input.readLine()) != null) continue;
                return null;
            } while (!line.startsWith("@<TRIPOS>MOLECULE") && (line.startsWith("#") || line.trim().length() <= 0));
            if (this.firstLineisMolecule) {
                molecule.setTitle(line);
            } else {
                line = this.input.readLine();
                molecule.setTitle(line);
            }
            String counts = this.input.readLine();
            StringTokenizer tokenizer = new StringTokenizer(counts);
            try {
                atomCount = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException nfExc) {
                String error = "Error while reading atom count from MOLECULE block";
                logger.error((Object)error);
                logger.debug((Object)nfExc);
                throw new CDKException(error, (Throwable)nfExc);
            }
            if (tokenizer.hasMoreTokens()) {
                try {
                    bondCount = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException nfExc) {
                    String error = "Error while reading atom and bond counts";
                    logger.error((Object)error);
                    logger.debug((Object)nfExc);
                    throw new CDKException(error, (Throwable)nfExc);
                }
            } else {
                bondCount = 0;
            }
            logger.info((Object)"Reading #atoms: ", new Object[]{atomCount});
            logger.info((Object)"Reading #bonds: ", new Object[]{bondCount});
            logger.warn((Object)"Not reading molecule qualifiers");
            line = this.input.readLine();
            boolean molend = false;
            while (line != null) {
                int i;
                if (line.startsWith("@<TRIPOS>MOLECULE")) {
                    molend = true;
                    break;
                }
                if (line.startsWith("@<TRIPOS>ATOM")) {
                    logger.info((Object)"Reading atom block");
                    for (i = 0; i < atomCount; ++i) {
                        IAtomType atomType;
                        line = this.input.readLine().trim();
                        if (line.startsWith("@<TRIPOS>MOLECULE")) {
                            molend = true;
                            break;
                        }
                        tokenizer = new StringTokenizer(line);
                        tokenizer.nextToken();
                        String nameStr = tokenizer.nextToken();
                        String xStr = tokenizer.nextToken();
                        String yStr = tokenizer.nextToken();
                        String zStr = tokenizer.nextToken();
                        String atomTypeStr = tokenizer.nextToken();
                        if (ATOM_TYPE_ALIASES.containsKey(atomTypeStr)) {
                            atomTypeStr = ATOM_TYPE_ALIASES.get(atomTypeStr);
                        }
                        IAtom atom = (IAtom)molecule.getBuilder().newInstance(IAtom.class, new Object[0]);
                        try {
                            atomType = atFactory.getAtomType(atomTypeStr);
                        }
                        catch (Exception exception) {
                            atomType = null;
                        }
                        if (atomType == null && this.isElementSymbol(atomTypeStr)) {
                            atom.setSymbol(atomTypeStr);
                        } else {
                            if (atomType == null) {
                                atomType = atFactory.getAtomType("X");
                                logger.error((Object)"Could not find specified atom type: ", new Object[]{atomTypeStr});
                            }
                            AtomTypeManipulator.configure((IAtom)atom, (IAtomType)atomType);
                        }
                        atom.setAtomicNumber(Integer.valueOf(Elements.ofString((String)atom.getSymbol()).number()));
                        atom.setID(nameStr);
                        atom.setAtomTypeName(atomTypeStr);
                        try {
                            double x = Double.parseDouble(xStr);
                            double y = Double.parseDouble(yStr);
                            double z = Double.parseDouble(zStr);
                            atom.setPoint3d(new Point3d(x, y, z));
                        }
                        catch (NumberFormatException nfExc) {
                            String error = "Error while reading atom coordinates";
                            logger.error((Object)error);
                            logger.debug((Object)nfExc);
                            throw new CDKException(error, (Throwable)nfExc);
                        }
                        molecule.addAtom(atom);
                    }
                } else if (line.startsWith("@<TRIPOS>BOND")) {
                    logger.info((Object)"Reading bond block");
                    for (i = 0; i < bondCount; ++i) {
                        line = this.input.readLine();
                        if (line.startsWith("@<TRIPOS>MOLECULE")) {
                            molend = true;
                            break;
                        }
                        tokenizer = new StringTokenizer(line);
                        tokenizer.nextToken();
                        String atom1Str = tokenizer.nextToken();
                        String atom2Str = tokenizer.nextToken();
                        String orderStr = tokenizer.nextToken();
                        try {
                            int atom1 = Integer.parseInt(atom1Str);
                            int atom2 = Integer.parseInt(atom2Str);
                            if ("nc".equals(orderStr)) continue;
                            IBond bond = (IBond)molecule.getBuilder().newInstance(IBond.class, new Object[]{molecule.getAtom(atom1 - 1), molecule.getAtom(atom2 - 1)});
                            if ("1".equals(orderStr)) {
                                bond.setOrder(IBond.Order.SINGLE);
                            } else if ("2".equals(orderStr)) {
                                bond.setOrder(IBond.Order.DOUBLE);
                            } else if ("3".equals(orderStr)) {
                                bond.setOrder(IBond.Order.TRIPLE);
                            } else if ("am".equals(orderStr) || "ar".equals(orderStr)) {
                                bond.setOrder(IBond.Order.SINGLE);
                                bond.setFlag(32, true);
                                bond.getBegin().setFlag(32, true);
                                bond.getEnd().setFlag(32, true);
                            } else if ("du".equals(orderStr)) {
                                bond.setOrder(IBond.Order.SINGLE);
                            } else if ("un".equals(orderStr)) {
                                bond.setOrder(IBond.Order.SINGLE);
                            }
                            molecule.addBond(bond);
                            continue;
                        }
                        catch (NumberFormatException nfExc) {
                            String error = "Error while reading bond information";
                            logger.error((Object)error);
                            logger.debug((Object)nfExc);
                            throw new CDKException(error, (Throwable)nfExc);
                        }
                    }
                }
                if (molend) {
                    return molecule;
                }
                line = this.input.readLine();
            }
        }
        catch (IOException exception) {
            String error = "Error while reading general structure";
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        return molecule;
    }

    private boolean isElementSymbol(String atomTypeStr) {
        for (int i = 1; i < PeriodicTable.getElementCount(); ++i) {
            if (!PeriodicTable.getSymbol((int)i).equals(atomTypeStr)) continue;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

