/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLRuntimeException;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLObjectHelper {
    private XMLObjectHelper() {
    }

    public static <T extends XMLObject> T cloneXMLObject(T originalXMLObject) throws MarshallingException, UnmarshallingException {
        return XMLObjectHelper.cloneXMLObject(originalXMLObject, false);
    }

    public static <T extends XMLObject> T cloneXMLObject(T originalXMLObject, boolean rootInNewDocument) throws MarshallingException, UnmarshallingException {
        if (originalXMLObject == null) {
            return null;
        }
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(originalXMLObject);
        Element origElement = marshaller.marshall(originalXMLObject);
        Element clonedElement = null;
        if (rootInNewDocument) {
            try {
                Document newDocument = Configuration.getParserPool().newDocument();
                clonedElement = (Element)newDocument.importNode(origElement, true);
                newDocument.appendChild(clonedElement);
            }
            catch (XMLParserException e) {
                throw new XMLRuntimeException("Error obtaining new Document from parser pool", e);
            }
        } else {
            clonedElement = (Element)origElement.cloneNode(true);
        }
        Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(clonedElement);
        XMLObject clonedXMLObject = unmarshaller.unmarshall(clonedElement);
        return (T)clonedXMLObject;
    }

    public static XMLObject unmarshallFromInputStream(ParserPool parserPool, InputStream inputStream) throws XMLParserException, UnmarshallingException {
        Logger log = XMLObjectHelper.getLogger();
        log.debug("Parsing InputStream into DOM document");
        Document messageDoc = parserPool.parse(inputStream);
        Element messageElem = messageDoc.getDocumentElement();
        if (log.isTraceEnabled()) {
            log.trace("Resultant DOM message was:");
            log.trace(XMLHelper.nodeToString(messageElem));
        }
        log.debug("Unmarshalling DOM parsed from InputStream");
        Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(messageElem);
        if (unmarshaller == null) {
            log.error("Unable to unmarshall InputStream, no unmarshaller registered for element " + XMLHelper.getNodeQName(messageElem));
            throw new UnmarshallingException("Unable to unmarshall InputStream, no unmarshaller registered for element " + XMLHelper.getNodeQName(messageElem));
        }
        XMLObject message = unmarshaller.unmarshall(messageElem);
        log.debug("InputStream succesfully unmarshalled");
        return message;
    }

    public static XMLObject unmarshallFromReader(ParserPool parserPool, Reader reader) throws XMLParserException, UnmarshallingException {
        Logger log = XMLObjectHelper.getLogger();
        log.debug("Parsing Reader into DOM document");
        Document messageDoc = parserPool.parse(reader);
        Element messageElem = messageDoc.getDocumentElement();
        if (log.isTraceEnabled()) {
            log.trace("Resultant DOM message was:");
            log.trace(XMLHelper.nodeToString(messageElem));
        }
        log.debug("Unmarshalling DOM parsed from Reader");
        Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(messageElem);
        if (unmarshaller == null) {
            log.error("Unable to unmarshall Reader, no unmarshaller registered for element " + XMLHelper.getNodeQName(messageElem));
            throw new UnmarshallingException("Unable to unmarshall Reader, no unmarshaller registered for element " + XMLHelper.getNodeQName(messageElem));
        }
        XMLObject message = unmarshaller.unmarshall(messageElem);
        log.debug("Reader succesfully unmarshalled");
        return message;
    }

    public static Element marshall(XMLObject xmlObject) throws MarshallingException {
        Logger log = XMLObjectHelper.getLogger();
        log.debug("Marshalling XMLObject");
        if (xmlObject.getDOM() != null) {
            log.debug("XMLObject already had cached DOM, returning that element");
            return xmlObject.getDOM();
        }
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(xmlObject);
        if (marshaller == null) {
            log.error("Unable to marshall XMLOBject, no marshaller registered for object: " + xmlObject.getElementQName());
        }
        Element messageElem = marshaller.marshall(xmlObject);
        if (log.isTraceEnabled()) {
            log.trace("Marshalled XMLObject into DOM:");
            log.trace(XMLHelper.nodeToString(messageElem));
        }
        return messageElem;
    }

    public static void marshallToOutputStream(XMLObject xmlObject, OutputStream outputStream) throws MarshallingException {
        Element element = XMLObjectHelper.marshall(xmlObject);
        XMLHelper.writeNode((Node)element, outputStream);
    }

    public static void marshallToWriter(XMLObject xmlObject, Writer writer) throws MarshallingException {
        Element element = XMLObjectHelper.marshall(xmlObject);
        XMLHelper.writeNode((Node)element, writer);
    }

    public static String lookupNamespaceURI(XMLObject xmlObject, String prefix) {
        XMLObject current = xmlObject;
        while (current != null) {
            for (Namespace ns : current.getNamespaces()) {
                if (!DatatypeHelper.safeEquals(ns.getNamespacePrefix(), prefix)) continue;
                return ns.getNamespaceURI();
            }
            current = current.getParent();
        }
        return null;
    }

    public static String lookupNamespacePrefix(XMLObject xmlObject, String namespaceURI) {
        XMLObject current = xmlObject;
        while (current != null) {
            for (Namespace ns : current.getNamespaces()) {
                if (!DatatypeHelper.safeEquals(ns.getNamespaceURI(), namespaceURI)) continue;
                return ns.getNamespacePrefix();
            }
            current = current.getParent();
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(XMLObjectHelper.class);
    }
}

