/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.jcip.annotations.NotThreadSafe;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.LazyList;
import org.opensaml.xml.util.LazyMap;
import org.opensaml.xml.util.ListView;
import org.opensaml.xml.util.XMLObjectChildrenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class IndexedXMLObjectChildrenList<ElementType extends XMLObject>
extends XMLObjectChildrenList<ElementType> {
    private Map<QName, List<ElementType>> objectIndex = new LazyMap<QName, List<ElementType>>();

    public IndexedXMLObjectChildrenList(XMLObject parent) {
        super(parent);
    }

    public IndexedXMLObjectChildrenList(XMLObject parent, Collection<ElementType> col) {
        super(parent);
        this.addAll(col);
    }

    @Override
    public void clear() {
        super.clear();
        this.objectIndex.clear();
    }

    public List<ElementType> get(QName typeOrName) {
        return this.objectIndex.get(typeOrName);
    }

    @Override
    public ElementType set(int index, ElementType element) {
        ElementType returnValue = super.set(index, element);
        this.removeElementFromIndex(returnValue);
        this.indexElement(element);
        return returnValue;
    }

    @Override
    public void add(int index, ElementType element) {
        super.add(index, element);
        this.indexElement(element);
    }

    @Override
    public ElementType remove(int index) {
        Object returnValue = super.remove(index);
        this.removeElementFromIndex(returnValue);
        return (ElementType)returnValue;
    }

    @Override
    public boolean remove(ElementType element) {
        boolean elementRemoved = false;
        elementRemoved = super.remove(element);
        if (elementRemoved) {
            this.removeElementFromIndex(element);
        }
        return elementRemoved;
    }

    public List<? extends ElementType> subList(QName index) {
        if (!this.objectIndex.containsKey(index)) {
            this.objectIndex.put(index, new LazyList());
        }
        return new ListView(this, index);
    }

    protected void indexElement(ElementType element) {
        if (element == null) {
            return;
        }
        QName type = element.getSchemaType();
        if (type != null) {
            this.indexElement(type, element);
        }
        this.indexElement(element.getElementQName(), element);
    }

    protected void indexElement(QName index, ElementType element) {
        List<ElementType> objects = this.objectIndex.get(index);
        if (objects == null) {
            objects = new LazyList();
            this.objectIndex.put(index, objects);
        }
        objects.add(element);
    }

    protected void removeElementFromIndex(ElementType element) {
        if (element == null) {
            return;
        }
        QName type = element.getSchemaType();
        if (type != null) {
            this.removeElementFromIndex(type, element);
        }
        this.removeElementFromIndex(element.getElementQName(), element);
    }

    protected void removeElementFromIndex(QName index, ElementType element) {
        List<ElementType> objects = this.objectIndex.get(index);
        if (objects != null) {
            objects.remove(element);
        }
        if (objects.size() == 0) {
            this.objectIndex.remove(index);
        }
    }
}

