/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingSignaturePrevalidator
implements SignaturePrevalidator {
    private Logger log = LoggerFactory.getLogger(ChainingSignaturePrevalidator.class);
    private List<SignaturePrevalidator> validators;

    public ChainingSignaturePrevalidator(@Nonnull List<SignaturePrevalidator> validatorChain) {
        Constraint.isNotNull(validatorChain, (String)"SignaturePrevalidator list was null");
        this.validators = Lists.newArrayList((Iterable)Collections2.filter(validatorChain, (Predicate)Predicates.notNull()));
    }

    public void validate(@Nonnull Signature signature) throws SignatureException {
        for (SignaturePrevalidator validator : this.validators) {
            this.log.debug("Validating signature using prevalidator: {}", (Object)validator.getClass().getName());
            validator.validate(signature);
        }
    }
}

