/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicWhitelistBlacklistConfiguration;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEncryptionConfiguration
extends BasicWhitelistBlacklistConfiguration
implements EncryptionConfiguration {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicEncryptionConfiguration.class);
    @Nonnull
    @NonnullElements
    private List<Credential> dataEncryptionCredentials = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<String> dataEncryptionAlgorithms = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<Credential> keyTransportEncryptionCredentials = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private List<String> keyTransportEncryptionAlgorithms = Collections.emptyList();
    @Nullable
    private NamedKeyInfoGeneratorManager dataKeyInfoGeneratorManager;
    @Nullable
    private NamedKeyInfoGeneratorManager keyTransportKeyInfoGeneratorManager;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Credential> getDataEncryptionCredentials() {
        return ImmutableList.copyOf(this.dataEncryptionCredentials);
    }

    public void setDataEncryptionCredentials(@Nullable List<Credential> credentials) {
        if (credentials == null) {
            this.dataEncryptionCredentials = Collections.emptyList();
            return;
        }
        this.dataEncryptionCredentials = Lists.newArrayList((Iterable)Collections2.filter(credentials, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getDataEncryptionAlgorithms() {
        return ImmutableList.copyOf(this.dataEncryptionAlgorithms);
    }

    public void setDataEncryptionAlgorithms(@Nullable List<String> algorithms) {
        if (algorithms == null) {
            this.dataEncryptionAlgorithms = Collections.emptyList();
            return;
        }
        this.dataEncryptionAlgorithms = Lists.newArrayList((Iterable)StringSupport.normalizeStringCollection(algorithms));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Credential> getKeyTransportEncryptionCredentials() {
        return ImmutableList.copyOf(this.keyTransportEncryptionCredentials);
    }

    public void setKeyTransportEncryptionCredentials(@Nullable List<Credential> credentials) {
        if (credentials == null) {
            this.keyTransportEncryptionCredentials = Collections.emptyList();
            return;
        }
        this.keyTransportEncryptionCredentials = Lists.newArrayList((Iterable)Collections2.filter(credentials, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getKeyTransportEncryptionAlgorithms() {
        return ImmutableList.copyOf(this.keyTransportEncryptionAlgorithms);
    }

    public void setKeyTransportEncryptionAlgorithms(@Nullable List<String> algorithms) {
        if (algorithms == null) {
            this.keyTransportEncryptionAlgorithms = Collections.emptyList();
            return;
        }
        this.keyTransportEncryptionAlgorithms = Lists.newArrayList((Iterable)StringSupport.normalizeStringCollection(algorithms));
    }

    @Nullable
    public NamedKeyInfoGeneratorManager getDataKeyInfoGeneratorManager() {
        return this.dataKeyInfoGeneratorManager;
    }

    public void setDataKeyInfoGeneratorManager(@Nullable NamedKeyInfoGeneratorManager keyInfoManager) {
        this.dataKeyInfoGeneratorManager = keyInfoManager;
    }

    @Nullable
    public NamedKeyInfoGeneratorManager getKeyTransportKeyInfoGeneratorManager() {
        return this.keyTransportKeyInfoGeneratorManager;
    }

    public void setKeyTransportKeyInfoGeneratorManager(@Nullable NamedKeyInfoGeneratorManager keyInfoManager) {
        this.keyTransportKeyInfoGeneratorManager = keyInfoManager;
    }
}

