/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.xacml.impl.AbstractXACMLObjectMarshaller;
import org.opensaml.xacml.policy.PolicySetType;
import org.w3c.dom.Element;

import com.google.common.base.Strings;

/** Marshaller for {@link PolicySetType} objects. */
public class PolicySetTypeMarshaller extends AbstractXACMLObjectMarshaller {

    /** {@inheritDoc} */
    @Override
    protected void marshallAttributes(final XMLObject xmlObject, final Element domElement) throws MarshallingException {
        final PolicySetType policySet = (PolicySetType) xmlObject;

        if (!Strings.isNullOrEmpty(policySet.getPolicySetId())) {
            domElement.setAttributeNS(null, PolicySetType.POLICY_SET_ID_ATTRIB_NAME, policySet.getPolicySetId());
        }
        if (!Strings.isNullOrEmpty(policySet.getVersion())) {
            domElement.setAttributeNS(null, PolicySetType.VERSION_ATTRIB_NAME, policySet.getVersion());
        }
        if (!Strings.isNullOrEmpty(policySet.getPolicyCombiningAlgoId())) {
            domElement.setAttributeNS(null, PolicySetType.POLICY_COMBINING_ALG_ID_ATTRIB_NAME, policySet
                    .getPolicyCombiningAlgoId());
        }
    }

}